/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.design.nested;

import com.vaadin.tests.design.nested.MyDesignRoot;
import com.vaadin.ui.Component;
import com.vaadin.ui.declarative.DesignContext;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WriteNestedTemplatesTest {
    private MyDesignRoot root;
    private Element design;

    @Before
    public void setUp() {
        this.root = new MyDesignRoot();
        this.design = this.createDesign();
    }

    private Element createDesign() {
        Element design = new Element(Tag.valueOf((String)"vaadin-vertical-layout"), "", new Attributes());
        DesignContext designContext = new DesignContext();
        designContext.setRootComponent((Component)this.root);
        this.root.writeDesign(design, designContext);
        return design;
    }

    @Test
    public void testChildRendered() {
        Assert.assertEquals((String)"Root layout must have one child", (long)1L, (long)this.design.children().size());
        Assert.assertEquals((Object)"com_vaadin_tests_design_nested-my-extended-child-design", (Object)this.design.child(0).tagName());
    }

    @Test
    public void rootCaptionIsWritten() {
        Assert.assertTrue((boolean)this.design.hasAttr("caption"));
        Assert.assertThat((Object)this.design.attr("caption"), (Matcher)CoreMatchers.is((Object)"root caption"));
    }

    @Test
    public void childCaptionIsWritten() {
        Assert.assertTrue((boolean)this.design.child(0).hasAttr("caption"));
        Assert.assertThat((Object)this.design.child(0).attr("caption"), (Matcher)CoreMatchers.is((Object)"child caption"));
    }

    @Test
    public void defaultCaptionIsNotOverwritten() {
        this.root.childDesign.setCaption("Default caption for child design");
        this.design = this.createDesign();
        Assert.assertFalse((boolean)this.design.child(0).hasAttr("caption"));
    }

    @Test
    public void childDesignChildrenIsNotWrittenInRootTemplate() {
        Assert.assertThat((Object)this.design.child(0).children().size(), (Matcher)CoreMatchers.is((Object)0));
    }
}

