/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.design.nested;

import com.vaadin.tests.design.nested.customlayouts.CustomAbsoluteLayout;
import com.vaadin.tests.design.nested.customlayouts.CustomAccordion;
import com.vaadin.tests.design.nested.customlayouts.CustomCssLayout;
import com.vaadin.tests.design.nested.customlayouts.CustomFormLayout;
import com.vaadin.tests.design.nested.customlayouts.CustomGridLayout;
import com.vaadin.tests.design.nested.customlayouts.CustomHorizontalLayout;
import com.vaadin.tests.design.nested.customlayouts.CustomHorizontalSplitPanel;
import com.vaadin.tests.design.nested.customlayouts.CustomPanel;
import com.vaadin.tests.design.nested.customlayouts.CustomTabSheet;
import com.vaadin.tests.design.nested.customlayouts.CustomVerticalLayout;
import com.vaadin.tests.design.nested.customlayouts.CustomVerticalSplitPanel;
import com.vaadin.ui.Component;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.declarative.Design;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.junit.Test;

public class NestedCustomLayoutsTest {
    private static final String PACKAGE_MAPPING = "com_vaadin_tests_design_nested_customlayouts:com.vaadin.tests.design.nested.customlayouts";

    @Test
    public void testNestedLayouts() throws IOException {
        VerticalLayout rootLayout = this.createRootLayout();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Design.write((Component)rootLayout, (OutputStream)out);
        Document doc = Jsoup.parse((String)out.toString(StandardCharsets.UTF_8.name()));
        MatcherAssert.assertThat((Object)doc.head().child(0).attr("name"), (Matcher)CoreMatchers.is((Object)"package-mapping"));
        MatcherAssert.assertThat((Object)doc.head().child(0).attr("content"), (Matcher)CoreMatchers.is((Object)PACKAGE_MAPPING));
        this.assertChildrenCount(doc);
    }

    private VerticalLayout createRootLayout() {
        VerticalLayout rootLayout = new VerticalLayout();
        rootLayout.addComponent((Component)new CustomAbsoluteLayout());
        rootLayout.addComponent((Component)new CustomAccordion());
        rootLayout.addComponent((Component)new CustomCssLayout());
        rootLayout.addComponent((Component)new CustomFormLayout());
        rootLayout.addComponent((Component)new CustomGridLayout());
        rootLayout.addComponent((Component)new CustomHorizontalLayout());
        rootLayout.addComponent((Component)new CustomHorizontalSplitPanel());
        rootLayout.addComponent((Component)new CustomPanel());
        rootLayout.addComponent((Component)new CustomTabSheet());
        rootLayout.addComponent((Component)new CustomVerticalLayout());
        rootLayout.addComponent((Component)new CustomVerticalSplitPanel());
        return rootLayout;
    }

    private void assertChildrenCount(Document doc) {
        Element rootNode = doc.body().child(0);
        MatcherAssert.assertThat((Object)rootNode.children().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        for (Element child : rootNode.children()) {
            MatcherAssert.assertThat((Object)child.children().size(), (Matcher)CoreMatchers.is((Object)0));
        }
    }
}

