/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.design;

import com.vaadin.tests.design.InvalidLayoutTemplate;
import com.vaadin.tests.design.LayoutTemplate;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.declarative.Design;
import com.vaadin.ui.declarative.DesignContext;
import com.vaadin.ui.declarative.DesignException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ParseLayoutTest {
    private DesignContext ctx;

    @Before
    public void setUp() throws Exception {
        this.ctx = Design.read((InputStream)this.getClass().getResourceAsStream("testFile.html"), null);
    }

    @Test
    public void buttonWithIdIsParsed() {
        Component button = this.ctx.getComponentByLocalId("firstButton");
        Assert.assertThat((Object)this.ctx.getComponentByCaption("Native click me"), (Matcher)CoreMatchers.is((Object)button));
        Assert.assertThat((Object)button.getCaption(), (Matcher)CoreMatchers.is((Object)"Native click me"));
    }

    @Test
    public void buttonWithIdAndLocalIdIsParsed() {
        Component button = this.ctx.getComponentById("secondButton");
        Assert.assertThat((Object)this.ctx.getComponentByCaption("Another button"), (Matcher)CoreMatchers.is((Object)button));
        Assert.assertThat((Object)this.ctx.getComponentByLocalId("localID"), (Matcher)CoreMatchers.is((Object)button));
        Assert.assertThat((Object)button.getCaption(), (Matcher)CoreMatchers.is((Object)"Another button"));
    }

    @Test
    public void buttonWithoutIdsIsParsed() {
        Assert.assertThat((Object)this.ctx.getComponentByCaption("Yet another button"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }

    @Test
    public void serializationPreservesProperties() throws IOException {
        ByteArrayOutputStream out = this.serializeDesign(this.ctx);
        this.ctx = this.deSerializeDesign(out);
        this.assertButtonProperties();
    }

    @Test
    public void serializationPreservesHierarchy() throws IOException {
        ByteArrayOutputStream out = this.serializeDesign(this.ctx);
        this.ctx = this.deSerializeDesign(out);
        this.assertComponentHierarchy();
    }

    @Test
    public void designIsSerializedWithCorrectPrefixesAndPackageNames() throws IOException {
        ByteArrayOutputStream out = this.serializeDesign(this.ctx);
        String[] expectedPrefixes = new String[]{"my"};
        String[] expectedPackageNames = new String[]{"com.addon.mypackage"};
        int index = 0;
        Document doc = Jsoup.parse((String)out.toString(StandardCharsets.UTF_8.name()));
        Element head = doc.head();
        for (Node child : head.childNodes()) {
            String name;
            if (!"meta".equals(child.nodeName()) || !"package-mapping".equals(name = child.attributes().get("name"))) continue;
            String content = child.attributes().get("content");
            String[] parts = content.split(":");
            Assert.assertEquals((String)"Unexpected prefix.", (Object)expectedPrefixes[index], (Object)parts[0]);
            Assert.assertEquals((String)"Unexpected package name.", (Object)expectedPackageNames[index], (Object)parts[1]);
            ++index;
        }
        Assert.assertEquals((String)"Unexpected number of prefix - package name pairs.", (long)1L, (long)index);
    }

    private DesignContext deSerializeDesign(ByteArrayOutputStream out) {
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        return Design.read((InputStream)in, null);
    }

    private ByteArrayOutputStream serializeDesign(DesignContext context) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Design.write((DesignContext)context, (OutputStream)out);
        return out;
    }

    private void assertButtonProperties() {
        this.buttonWithIdAndLocalIdIsParsed();
        this.buttonWithIdIsParsed();
        this.buttonWithoutIdsIsParsed();
    }

    @Test
    public void fieldsAreBoundToATemplate() throws IOException {
        LayoutTemplate template = new LayoutTemplate();
        InputStream htmlFile = this.getClass().getResourceAsStream("testFile.html");
        Design.read((InputStream)htmlFile, (Component)template);
        Assert.assertNotNull((Object)template.getFirstButton());
        Assert.assertNotNull((Object)template.getSecondButton());
        Assert.assertNotNull((Object)template.getYetanotherbutton());
        Assert.assertNotNull((Object)template.getClickme());
        Assert.assertEquals((Object)"Native click me", (Object)template.getFirstButton().getCaption());
    }

    @Test(expected=DesignException.class)
    public void fieldsCannotBeBoundToAnInvalidTemplate() throws IOException {
        InvalidLayoutTemplate template = new InvalidLayoutTemplate();
        InputStream htmlFile = this.getClass().getResourceAsStream("testFile.html");
        Design.read((InputStream)htmlFile, (Component)template);
    }

    @Test
    public void rootHasCorrectComponents() {
        Component root = this.ctx.getRootComponent();
        VerticalLayout vlayout = (VerticalLayout)root;
        Assert.assertThat((Object)vlayout.getComponentCount(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void rootChildHasCorrectComponents() {
        Component root = this.ctx.getRootComponent();
        VerticalLayout vlayout = (VerticalLayout)root;
        HorizontalLayout hlayout = (HorizontalLayout)vlayout.getComponent(0);
        Assert.assertThat((Object)hlayout.getComponentCount(), (Matcher)CoreMatchers.is((Object)5));
        Assert.assertThat((Object)hlayout.getComponent(0).getCaption(), (Matcher)CoreMatchers.is((Object)"FooBar"));
        Assert.assertThat((Object)hlayout.getComponent(1).getCaption(), (Matcher)CoreMatchers.is((Object)"Native click me"));
        Assert.assertThat((Object)hlayout.getComponent(2).getCaption(), (Matcher)CoreMatchers.is((Object)"Another button"));
        Assert.assertThat((Object)hlayout.getComponent(3).getCaption(), (Matcher)CoreMatchers.is((Object)"Yet another button"));
        Assert.assertThat((Object)hlayout.getComponent(4).getCaption(), (Matcher)CoreMatchers.is((Object)"Click me"));
        Assert.assertThat((Object)Float.valueOf(hlayout.getComponent(4).getWidth()), (Matcher)CoreMatchers.is((Object)Float.valueOf(150.0f)));
        this.assertTextField(vlayout);
        this.assertPasswordField(vlayout);
    }

    private void assertComponentHierarchy() {
        this.rootHasCorrectComponents();
        this.rootChildHasCorrectComponents();
    }

    private void assertTextField(VerticalLayout vlayout) {
        TextField tf = (TextField)vlayout.getComponent(1);
        Assert.assertThat((Object)tf.getCaption(), (Matcher)CoreMatchers.is((Object)"Text input"));
    }

    private void assertPasswordField(VerticalLayout layout) {
        PasswordField pf = (PasswordField)layout.getComponent(2);
        Assert.assertThat((Object)pf.getCaption(), (Matcher)CoreMatchers.is((Object)"Password field"));
        Assert.assertThat((Object)Float.valueOf(pf.getWidth()), (Matcher)CoreMatchers.is((Object)Float.valueOf(300.0f)));
        Assert.assertThat((Object)Float.valueOf(pf.getHeight()), (Matcher)CoreMatchers.is((Object)Float.valueOf(200.0f)));
    }
}

