/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.design;

import com.vaadin.annotations.DesignRoot;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.declarative.Design;
import com.vaadin.ui.declarative.DesignContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.junit.Assert;
import org.junit.Test;

public class FieldNameWhichConflictsWithGettersTest {
    @Test
    public void readWithConflictingFields() {
        MyVerticalLayout v = new MyVerticalLayout();
        Assert.assertNotNull((Object)v.caption);
        Assert.assertNotNull((Object)v.description);
    }

    @Test
    public void writeWithConflictingFields() throws IOException {
        VerticalLayout v = new VerticalLayout();
        Label l = new Label();
        l.setId("caption");
        TextField tf = new TextField();
        v.addComponents(new Component[]{l, tf});
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DesignContext context = new DesignContext();
        context.setComponentLocalId((Component)tf, "description");
        context.setRootComponent((Component)v);
        Design.write((DesignContext)context, (OutputStream)baos);
        String str = baos.toString(StandardCharsets.UTF_8.name());
        Document doc = Jsoup.parse((String)str);
        Element body = doc.body();
        Element captionElement = body.getElementById("caption");
        Assert.assertNotNull((Object)captionElement);
        Assert.assertEquals((Object)"vaadin-label", (Object)captionElement.tagName());
        Element descriptionElement = captionElement.nextElementSibling();
        Assert.assertNotNull((Object)descriptionElement);
        Assert.assertEquals((Object)"vaadin-text-field", (Object)descriptionElement.tagName());
        Assert.assertEquals((Object)"description", (Object)descriptionElement.attr("_id"));
    }

    @DesignRoot(value="MyVerticalLayout.html")
    public static class MyVerticalLayout
    extends VerticalLayout {
        private Label caption;
        private TextField description;

        public MyVerticalLayout() {
            Design.read((Component)this);
        }
    }
}

