/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.design;

import com.vaadin.ui.AbsoluteLayout;
import com.vaadin.ui.Accordion;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.CustomLayout;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.HorizontalSplitPanel;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.SingleComponentContainer;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.VerticalSplitPanel;
import com.vaadin.ui.Window;
import com.vaadin.ui.declarative.Design;
import com.vaadin.ui.declarative.DesignContext;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.jsoup.nodes.Element;
import org.junit.Assert;
import org.junit.Test;

public class DesignContextLocalIdTest {
    @Test
    public void testSetLocalId() throws FileNotFoundException {
        DesignContext ctx = Design.read((InputStream)this.getClass().getResourceAsStream("local-ids.html"), (Component)new VerticalLayout());
        TextField tf = (TextField)ctx.getComponentByLocalId("foo");
        Button b = (Button)ctx.getComponentByLocalId("bar");
        ctx.setComponentLocalId((Component)b, "foo");
        Assert.assertEquals((String)"Found the wrong component by local id.", ctx.getComponentByLocalId("foo").getClass(), Button.class);
        Assert.assertEquals((String)"Found the wrong component by local id.", (Object)ctx.getComponentByLocalId("bar"), null);
        ctx.setComponentLocalId((Component)tf, "bar");
        Assert.assertEquals((String)"Found the wrong component by local id.", ctx.getComponentByLocalId("foo").getClass(), Button.class);
        Assert.assertEquals((String)"Found the wrong component by local id.", ctx.getComponentByLocalId("bar").getClass(), TextField.class);
    }

    @Test
    public void testWriteLocalId() {
        DesignContext ctx = new DesignContext();
        Button b = new Button();
        ctx.setComponentLocalId((Component)b, "button-id");
        Assert.assertEquals((Object)"button-id", (Object)ctx.createElement((Component)b).attr("_id"));
    }

    @Test
    public void testWriteChildLocalIds() throws Exception {
        SingleComponentContainer[] sctrs;
        DesignContext ctx = new DesignContext();
        ComponentContainer[] ctrs = new ComponentContainer[]{new AbsoluteLayout(), new CssLayout(), new GridLayout(1, 1), new CustomLayout(), new HorizontalLayout(), new VerticalLayout(), new Accordion(), new HorizontalSplitPanel(), new TabSheet(), new VerticalSplitPanel()};
        Button b = new Button();
        ctx.setComponentLocalId((Component)b, "button-id");
        for (ComponentContainer ctr : ctrs) {
            ctr.addComponent((Component)b);
            Element e = ctx.createElement((Component)ctr);
            Assert.assertEquals((String)("Unexpected child local id for " + ctr.getClass().getSimpleName()), (Object)"button-id", (Object)e.getElementsByTag("vaadin-button").first().attr("_id"));
        }
        for (SingleComponentContainer ctr : sctrs = new SingleComponentContainer[]{new Window(), new Panel()}) {
            ctr.setContent((Component)b);
            Element e = ctx.createElement((Component)ctr);
            Assert.assertEquals((String)("Unexpected child local id for " + ctr.getClass().getSimpleName()), (Object)"button-id", (Object)e.getElementsByTag("vaadin-button").first().attr("_id"));
        }
    }

    @Test
    public void testGetLocalId() {
        DesignContext ctx = new DesignContext();
        Label label = new Label();
        ctx.setComponentLocalId((Component)label, "my-local-id");
        ctx.setRootComponent((Component)label);
        Assert.assertEquals((Object)"my-local-id", (Object)ctx.getComponentLocalId((Component)label));
    }
}

