/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.design;

import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.declarative.Design;
import com.vaadin.ui.declarative.DesignContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;

public class ComponentMapperTest {
    private static final Design.ComponentMapper defaultMapper = Design.getComponentMapper();
    private static final ThreadLocal<Design.ComponentMapper> currentMapper = new ThreadLocal();

    @Test
    public void testCustomComponentMapperRead() {
        currentMapper.set((Design.ComponentMapper)new CustomComponentMapper());
        Component component = Design.read((InputStream)new ByteArrayInputStream("<custom-foobar />".getBytes()));
        Assert.assertTrue((String)("<custom-foobar> should resolve " + ComponentWithCustomTagName.class.getSimpleName()), (boolean)(component instanceof ComponentWithCustomTagName));
        Assert.assertEquals((Object)"custom-foobar", (Object)((ComponentWithCustomTagName)component).tagName);
    }

    @Test
    public void testCustomComponentMapperWrite() throws IOException {
        currentMapper.set((Design.ComponentMapper)new CustomComponentMapper());
        ComponentWithCustomTagName component = new ComponentWithCustomTagName();
        component.tagName = "custom-special";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Design.write((Component)component, (OutputStream)bos);
        String writtenDesign = new String(bos.toByteArray());
        Assert.assertTrue((String)("Written design should contain \"<custom-special\", but instead got " + writtenDesign), (boolean)writtenDesign.contains("<custom-special"));
    }

    public void cleanup() {
        currentMapper.remove();
    }

    static {
        Design.setComponentMapper((Design.ComponentMapper)new Design.ComponentMapper(){

            public Component tagToComponent(String tag, Design.ComponentFactory componentFactory, DesignContext context) {
                return this.getActualMapper().tagToComponent(tag, componentFactory, context);
            }

            public String componentToTag(Component component, DesignContext context) {
                return this.getActualMapper().componentToTag(component, context);
            }

            private Design.ComponentMapper getActualMapper() {
                Design.ComponentMapper mapper = (Design.ComponentMapper)currentMapper.get();
                if (mapper == null) {
                    mapper = defaultMapper;
                }
                return mapper;
            }
        });
    }

    public static class ComponentWithCustomTagName
    extends Label {
        private String tagName;
    }

    private final class CustomComponentMapper
    extends Design.DefaultComponentMapper {
        private CustomComponentMapper() {
        }

        public Component tagToComponent(String tag, Design.ComponentFactory componentFactory, DesignContext context) {
            if (tag.startsWith("custom-")) {
                ComponentWithCustomTagName component = (ComponentWithCustomTagName)componentFactory.createComponent(ComponentWithCustomTagName.class.getName(), context);
                component.tagName = tag;
                return component;
            }
            return super.tagToComponent(tag, componentFactory, context);
        }

        public String componentToTag(Component component, DesignContext context) {
            if (component instanceof ComponentWithCustomTagName) {
                ComponentWithCustomTagName withCustomTagName = (ComponentWithCustomTagName)component;
                return withCustomTagName.tagName;
            }
            return super.componentToTag(component, context);
        }
    }
}

