/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.data.converter;

import com.vaadin.data.Result;
import com.vaadin.data.ValueContext;
import com.vaadin.data.converter.StringToDoubleConverter;
import com.vaadin.tests.data.converter.AbstractConverterTest;
import org.junit.Assert;
import org.junit.Test;

public class StringToDoubleConverterTest
extends AbstractConverterTest {
    protected StringToDoubleConverter getConverter() {
        return new StringToDoubleConverter("Failed");
    }

    @Test
    public void testEmptyStringConversion() {
        this.assertValue(null, this.getConverter().convertToModel("", new ValueContext()));
    }

    @Test
    public void testValueConversion() {
        Result value = this.getConverter().convertToModel("10", new ValueContext());
        this.assertValue(10.0, value);
    }

    @Test
    public void testErrorMessage() {
        Result result = this.getConverter().convertToModel("abc", new ValueContext());
        Assert.assertTrue((boolean)result.isError());
        Assert.assertEquals((Object)"Failed", result.getMessage().get());
    }

    @Test
    public void customEmptyValue() {
        StringToDoubleConverter converter = new StringToDoubleConverter(Double.valueOf(0.0), this.getErrorMessage());
        this.assertValue(0.0, converter.convertToModel("", new ValueContext()));
        Assert.assertEquals((Object)"0", (Object)converter.convertToPresentation((Number)0.0, new ValueContext()));
    }
}

