/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.data.converter;

import com.vaadin.data.Result;
import com.vaadin.data.ValueContext;
import com.vaadin.data.converter.StringToBigIntegerConverter;
import com.vaadin.tests.data.converter.AbstractStringConverterTest;
import java.math.BigInteger;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class StringToBigIntegerConverterTest
extends AbstractStringConverterTest {
    protected StringToBigIntegerConverter getConverter() {
        return new StringToBigIntegerConverter(this.getErrorMessage());
    }

    @Test
    public void testValueParsing() {
        String bigInt = "1180591620717411303424";
        Result converted = this.getConverter().convertToModel(bigInt, new ValueContext());
        BigInteger expected = new BigInteger(bigInt);
        this.assertValue("Value bigger than max long was converted incorrectly", expected, converted);
    }

    @Test
    public void testValueFormatting() {
        BigInteger bd = new BigInteger("1000");
        String expected = "1.000";
        String converted = this.getConverter().convertToPresentation((Number)bd, new ValueContext(Locale.GERMAN));
        Assert.assertEquals((String)"Value with specific locale was converted incorrectly", (Object)expected, (Object)converted);
    }

    @Test
    public void customEmptyValue() {
        StringToBigIntegerConverter converter = new StringToBigIntegerConverter(BigInteger.ZERO, this.getErrorMessage());
        this.assertValue(BigInteger.ZERO, converter.convertToModel("", new ValueContext()));
        Assert.assertEquals((Object)"0", (Object)converter.convertToPresentation((Number)BigInteger.ZERO, new ValueContext()));
    }
}

