/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.data.converter;

import com.vaadin.data.Converter;
import com.vaadin.data.Result;
import com.vaadin.data.ValueContext;
import com.vaadin.server.SerializableFunction;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;

public class ConverterTest {
    SerializableFunction<String, Result<String>> toModel = (SerializableFunction & Serializable)presentation -> {
        if (presentation.startsWith("presentation-")) {
            return Result.ok((Object)presentation.substring("presentation-".length()));
        }
        return Result.error((String)("invalid prefix: " + presentation));
    };
    SerializableFunction<String, String> toPresentation = (SerializableFunction & Serializable)model -> "presentation-" + model;
    Converter<String, String> converter = Converter.from(this.toModel, this.toPresentation);

    @Test
    public void basicConversion() {
        Assert.assertEquals((Object)"presentation-123", (Object)this.converter.convertToPresentation((Object)"123", new ValueContext()));
        Assert.assertEquals((Object)"123", (Object)this.converter.convertToModel((Object)"presentation-123", new ValueContext()).getOrThrow((SerializableFunction & Serializable)msg -> new AssertionError(msg)));
    }
}

