/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.components.treegrid;

import com.vaadin.data.TreeData;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.TreeDataProvider;
import com.vaadin.event.CollapseEvent;
import com.vaadin.event.ExpandEvent;
import com.vaadin.tests.data.bean.Person;
import com.vaadin.ui.Grid;
import com.vaadin.ui.TreeGrid;
import com.vaadin.ui.renderers.Renderer;
import com.vaadin.ui.renderers.TextRenderer;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;

public class TreeGridTest {
    private TreeGrid<String> treeGrid = new TreeGrid();
    private boolean expandEventFired = false;
    private boolean collapseEventFired = false;

    @Test
    public void testChangeRendererOfHierarchyColumn() {
        this.treeGrid.addColumn(Object::toString).setId("foo");
        this.treeGrid.setHierarchyColumn("foo");
        this.treeGrid.getColumn("foo").setRenderer((Renderer)new TextRenderer());
    }

    @Test
    public void testExpandAndCollapseEvents() {
        TreeData treeData = new TreeData();
        treeData.addItem(null, (Object)"Foo");
        treeData.addItem((Object)"Foo", (Object)"Bar");
        treeData.addItem((Object)"Foo", (Object)"Baz");
        this.treeGrid.setDataProvider((DataProvider)new TreeDataProvider(treeData));
        this.treeGrid.addExpandListener((ExpandEvent.ExpandListener & Serializable)event -> {
            this.expandEventFired = true;
        });
        this.treeGrid.addCollapseListener((CollapseEvent.CollapseListener & Serializable)event -> {
            this.collapseEventFired = true;
        });
        Assert.assertFalse((boolean)this.expandEventFired);
        this.treeGrid.expand((Object[])new String[]{"Foo"});
        Assert.assertTrue((String)"Item not expanded", (boolean)this.treeGrid.isExpanded((Object)"Foo"));
        Assert.assertTrue((String)"Expand event not fired", (boolean)this.expandEventFired);
        Assert.assertFalse((boolean)this.collapseEventFired);
        this.treeGrid.collapse((Object[])new String[]{"Foo"});
        Assert.assertFalse((String)"Item not collapsed", (boolean)this.treeGrid.isExpanded((Object)"Foo"));
        Assert.assertTrue((String)"Collapse event not fired", (boolean)this.collapseEventFired);
    }

    @Test
    public void testSetAndGetHierarchyColumn() {
        Grid.Column column = this.treeGrid.addColumn(Object::toString).setId("foo");
        this.treeGrid.setHierarchyColumn("foo");
        Assert.assertEquals((String)"Hierarchy column was not correctly returned", (Object)column, (Object)this.treeGrid.getHierarchyColumn());
    }

    @Test
    public void testBeanTypeConstructor() {
        TreeGrid treeGrid = new TreeGrid(Person.class);
        Assert.assertEquals(Person.class, (Object)treeGrid.getBeanType());
    }
}

