/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.components.menubar;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.tests.design.DeclarativeTestBase;
import com.vaadin.ui.MenuBar;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Test;

public class MenuBarDeclarativeTest
extends DeclarativeTestBase<MenuBar> {
    @Test
    public void testReadWrite() throws IOException {
        String design = "<vaadin-menu-bar auto-open tabindex=5><menu checkable>Save</menu><menu description='Open a file'>Open</menu><menu disabled>Close</menu><menu icon='http://foo.bar/ico.png'>Help</menu><menu visible='false'>About</menu><menu>Sub<menu>Item</menu></menu><menu more>WTF?!</menu></vaadin-menu-bar>";
        MenuBar bar = new MenuBar();
        bar.setAutoOpen(true);
        bar.setHtmlContentAllowed(true);
        bar.setTabIndex(5);
        bar.addItem("Save", null).setCheckable(true);
        bar.addItem("Open", null).setDescription("Open a file");
        bar.addItem("Close", null).setEnabled(false);
        bar.addItem("Help", null).setIcon((Resource)new ExternalResource("http://foo.bar/ico.png"));
        bar.addItem("About", null).setVisible(false);
        bar.addItem("Sub", null).addItem("Item", null);
        MenuBar menuBar = bar;
        Objects.requireNonNull(menuBar);
        bar.setMoreMenuItem(new MenuBar.MenuItem(menuBar, "WTF?!", null, null));
        this.testWrite(design, bar);
        this.testRead(design, bar);
    }

    @Test
    public void testDescriptionContentMode() {
        String design = "<vaadin-menu-bar plain-text><menu description=\"This description is implicitly preformatted\">One</menu><menu description=\"This description\nis explicitly\n\npreformatted\">preformatted</menu><menu descriptioncontentmode=\"HTML\" description=\"<b>I</b> contain <br/> <e>html</e>\">HTML</menu><menu descriptioncontentmode=\"TEXT\" description=\"Just plain text\">plain text</menu></vaadin-menu-bar>";
        MenuBar menuBar = new MenuBar();
        menuBar.addItem("One", null).setDescription("This description is implicitly preformatted");
        menuBar.addItem("preformatted", null).setDescription("This description\nis explicitly\n\npreformatted", ContentMode.PREFORMATTED);
        menuBar.addItem("HTML", null).setDescription("<b>I</b> contain <br/> <e>html</e>", ContentMode.HTML);
        menuBar.addItem("plain text", null).setDescription("Just plain text", ContentMode.TEXT);
        this.testWrite(design, menuBar);
        this.testRead(design, menuBar);
    }

    @Test
    public void testTicketSpec1() throws IOException {
        String design = "<vaadin-menu-bar auto-open plain-text tabindex=5> <menu>File<menu>Save</menu><menu icon=\"theme://../runo/icons/16/folder.png\">Open</menu><menu separator /><menu disabled>Exit</menu><menu visible='false'>Not for everybody</menu></menu><menu description=\"This contains many items in sub menus\">Other<menu style-name=\"fancy\">Sub<menu checkable checked>Option 1 - no <b>html</b></menu><menu checkable>Option 2</menu><menu checkable>Option 3</menu></menu></menu><menu more icon=\"theme://icon.png\">foo</menu></vaadin-menu-bar>";
        MenuBar menuBar = new MenuBar();
        menuBar.setHtmlContentAllowed(false);
        menuBar.setTabIndex(5);
        menuBar.setAutoOpen(true);
        MenuBar.MenuItem fileMenu = menuBar.addItem("File", null);
        fileMenu.addItem("Save", null);
        fileMenu.addItem("Open", (Resource)new ThemeResource("../runo/icons/16/folder.png"), null);
        fileMenu.addSeparator();
        fileMenu.addItem("Exit", null).setEnabled(false);
        fileMenu.addItem("Not for everybody", null).setVisible(false);
        MenuBar.MenuItem otherMenu = menuBar.addItem("Other", null);
        otherMenu.setDescription("This contains many items in sub menus");
        MenuBar.MenuItem subMenu = otherMenu.addItem("Sub", null);
        subMenu.setStyleName("fancy");
        MenuBar.MenuItem option1 = subMenu.addItem("Option 1 - no <b>html</b>", null);
        option1.setCheckable(true);
        option1.setChecked(true);
        subMenu.addItem("Option 2", null).setCheckable(true);
        subMenu.addItem("Option 3", null).setCheckable(true);
        menuBar.setMoreMenuItem(null);
        MenuBar.MenuItem moreMenu = menuBar.getMoreMenuItem();
        moreMenu.setIcon((Resource)new ThemeResource("icon.png"));
        moreMenu.setText("foo");
        this.testRead(design, menuBar);
        this.testWrite(design, menuBar);
    }

    @Test
    public void testTicketSpec2() throws IOException {
        String design = "<vaadin-menu-bar><menu><b>File</b><menu><font style=\"color: red\">Save</font></menu><menu icon=\"theme://../runo/icons/16/folder.png\">Open</menu><menu separator /><menu disabled>Exit</menu></menu></vaadin-menu-bar>";
        MenuBar menuBar = new MenuBar();
        menuBar.setHtmlContentAllowed(true);
        MenuBar.MenuItem fileMenu = menuBar.addItem("<b>File</b>", null);
        fileMenu.addItem("<font style=\"color: red\">Save</font>", null);
        fileMenu.addItem("Open", (Resource)new ThemeResource("../runo/icons/16/folder.png"), null);
        fileMenu.addSeparator();
        fileMenu.addItem("Exit", null).setEnabled(false);
        this.testRead(design, menuBar);
        this.testWrite(design, menuBar);
    }

    @Override
    public MenuBar testRead(String design, MenuBar expected) {
        MenuBar result = super.testRead(design, expected);
        List expectedMenuItems = expected.getItems();
        List actualMenuItems = result.getItems();
        Assert.assertEquals((String)"Different amount of menu items", (long)expectedMenuItems.size(), (long)actualMenuItems.size());
        for (int i = 0; i < expectedMenuItems.size(); ++i) {
            this.compareMenus((MenuBar.MenuItem)expectedMenuItems.get(i), (MenuBar.MenuItem)actualMenuItems.get(i));
        }
        return result;
    }

    private void compareMenus(MenuBar.MenuItem expected, MenuBar.MenuItem actual) {
        String baseError = "Error Comparing MenuItem " + expected.getText() + ": ";
        Assert.assertEquals((String)(baseError + "Visibile"), (Object)expected.isVisible(), (Object)actual.isVisible());
        Assert.assertEquals((String)(baseError + "Checkable"), (Object)expected.isCheckable(), (Object)actual.isCheckable());
        Assert.assertEquals((String)(baseError + "Checked"), (Object)expected.isChecked(), (Object)actual.isChecked());
        Assert.assertEquals((String)(baseError + "Separator"), (Object)expected.isSeparator(), (Object)actual.isSeparator());
        Assert.assertEquals((String)(baseError + "Enabled"), (Object)expected.isEnabled(), (Object)actual.isEnabled());
        Assert.assertEquals((String)(baseError + "Text"), (Object)expected.getText(), (Object)actual.getText());
        Assert.assertEquals((String)(baseError + "Description"), (Object)expected.getDescription(), (Object)actual.getDescription());
        Assert.assertEquals((String)(baseError + "Style Name"), (Object)expected.getStyleName(), (Object)actual.getStyleName());
        Assert.assertEquals((String)(baseError + "Content Mode"), (Object)expected.getDescriptionContentMode(), (Object)actual.getDescriptionContentMode());
        if (expected.getIcon() != null) {
            Assert.assertNotNull((String)(baseError + "Icon was null"), (Object)actual.getIcon());
        } else if (actual.getIcon() != null) {
            Assert.fail((String)(baseError + "Icon should've been null"));
        }
        Assert.assertEquals((String)(baseError + "Has Children"), (Object)expected.hasChildren(), (Object)actual.hasChildren());
        if (expected.hasChildren()) {
            List children = expected.getChildren();
            List actualChildren = actual.getChildren();
            Assert.assertEquals((String)(baseError + "Child count"), (long)children.size(), (long)actualChildren.size());
            for (int i = 0; i < children.size(); ++i) {
                this.compareMenus((MenuBar.MenuItem)children.get(i), (MenuBar.MenuItem)actualChildren.get(i));
            }
        }
    }
}

