/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.components.grid;

import com.vaadin.data.HasValue;
import com.vaadin.data.provider.bov.Person;
import com.vaadin.event.selection.SingleSelectionEvent;
import com.vaadin.event.selection.SingleSelectionListener;
import com.vaadin.shared.Registration;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.components.grid.GridSelectionModel;
import com.vaadin.ui.components.grid.SingleSelectionModelImpl;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class GridSingleSelectionModelTest {
    public static final Person PERSON_C = new Person("c", 3);
    public static final Person PERSON_B = new Person("b", 2);
    public static final Person PERSON_A = new Person("a", 1);
    private List<Person> selectionChanges;
    private Grid<Person> grid;
    private SingleSelectionModelImpl<Person> selectionModel;

    @Before
    public void setUp() {
        this.grid = new Grid();
        this.grid.setItems((Object[])new Person[]{PERSON_A, PERSON_B, PERSON_C});
        this.selectionModel = (SingleSelectionModelImpl)this.grid.getSelectionModel();
        this.selectionChanges = new ArrayList<Person>();
        this.selectionModel.addSingleSelectionListener((SingleSelectionListener & Serializable)event -> this.selectionChanges.add((Person)event.getValue()));
    }

    @Test(expected=IllegalStateException.class)
    public void throwExceptionWhenSelectionIsDisallowed() {
        TestSingleSelectionModel model = new TestSingleSelectionModel();
        model.setSelectedFromClient("foo");
    }

    @Test(expected=IllegalStateException.class)
    public void selectionModelChanged_usingPreviousSelectionModel_throws() {
        this.grid.setSelectionMode(Grid.SelectionMode.MULTI);
        this.selectionModel.select((Object)PERSON_A);
    }

    @Test
    public void gridChangingSelectionModel_firesSelectionChangeEvent() {
        Grid customGrid = new Grid();
        customGrid.setItems((Object[])new String[]{"Foo", "Bar", "Baz"});
        ArrayList selectionChanges = new ArrayList();
        ArrayList oldSelectionValues = new ArrayList();
        ((SingleSelectionModelImpl)customGrid.getSelectionModel()).addSingleSelectionListener((SingleSelectionListener & Serializable)event -> {
            selectionChanges.add((String)event.getValue());
            oldSelectionValues.add((String)event.getOldValue());
        });
        customGrid.getSelectionModel().select((Object)"Foo");
        Assert.assertEquals((Object)"Foo", customGrid.getSelectionModel().getFirstSelectedItem().get());
        Assert.assertEquals(Arrays.asList("Foo"), selectionChanges);
        Assert.assertEquals(Arrays.asList(new String[]{null}), oldSelectionValues);
        customGrid.setSelectionMode(Grid.SelectionMode.MULTI);
        Assert.assertEquals(Arrays.asList("Foo", null), selectionChanges);
        Assert.assertEquals(Arrays.asList(null, "Foo"), oldSelectionValues);
    }

    @Test
    public void serverSideSelection_GridChangingSelectionModel_sendsUpdatedRowsToClient() {
        final CustomSingleSelectionModel customModel = new CustomSingleSelectionModel();
        Grid<String> customGrid = new Grid<String>(){
            {
                this.setSelectionModel((GridSelectionModel)customModel);
            }
        };
        customGrid.setItems((Object[])new String[]{"Foo", "Bar", "Baz"});
        customGrid.getDataCommunicator().beforeClientResponse(true);
        Assert.assertFalse((String)"Item should have been updated as selected", (boolean)customModel.generatedData.get("Foo"));
        Assert.assertFalse((String)"Item should have been updated as NOT selected", (boolean)customModel.generatedData.get("Bar"));
        Assert.assertFalse((String)"Item should have been updated as NOT selected", (boolean)customModel.generatedData.get("Baz"));
        customModel.generatedData.clear();
        customGrid.getSelectionModel().select((Object)"Foo");
        customGrid.getDataCommunicator().beforeClientResponse(false);
        Assert.assertTrue((String)"Item should have been updated as selected", (boolean)customModel.generatedData.get("Foo"));
        Assert.assertFalse((String)"Item should have NOT been updated", (boolean)customModel.generatedData.containsKey("Bar"));
        Assert.assertFalse((String)"Item should have NOT been updated", (boolean)customModel.generatedData.containsKey("Baz"));
        customModel.generatedData.clear();
        customGrid.setSelectionMode(Grid.SelectionMode.MULTI);
        customGrid.getDataCommunicator().beforeClientResponse(false);
        Assert.assertTrue((boolean)customModel.generatedData.isEmpty());
    }

    @Test
    public void testGridWithSingleSelection() {
        Grid gridWithStrings = new Grid();
        gridWithStrings.setItems((Object[])new String[]{"Foo", "Bar", "Baz"});
        GridSelectionModel model = gridWithStrings.getSelectionModel();
        Assert.assertFalse((boolean)model.isSelected((Object)"Foo"));
        model.select((Object)"Foo");
        Assert.assertTrue((boolean)model.isSelected((Object)"Foo"));
        Assert.assertEquals(Optional.of("Foo"), (Object)model.getFirstSelectedItem());
        model.select((Object)"Bar");
        Assert.assertFalse((boolean)model.isSelected((Object)"Foo"));
        Assert.assertTrue((boolean)model.isSelected((Object)"Bar"));
        model.deselect((Object)"Bar");
        Assert.assertFalse((boolean)model.isSelected((Object)"Bar"));
        Assert.assertFalse((boolean)model.getFirstSelectedItem().isPresent());
    }

    @Test
    public void select_isSelected() {
        this.selectionModel.select((Object)PERSON_B);
        Assert.assertTrue((boolean)this.selectionModel.getSelectedItem().isPresent());
        Assert.assertEquals((Object)PERSON_B, this.selectionModel.getSelectedItem().orElse(null));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(Optional.of(PERSON_B), (Object)this.selectionModel.getSelectedItem());
        Assert.assertEquals(Arrays.asList(PERSON_B), this.selectionChanges);
    }

    @Test
    public void selectDeselect() {
        this.selectionModel.select((Object)PERSON_B);
        this.selectionModel.deselect((Object)PERSON_B);
        Assert.assertFalse((boolean)this.selectionModel.getSelectedItem().isPresent());
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertFalse((boolean)this.selectionModel.getSelectedItem().isPresent());
        Assert.assertEquals(Arrays.asList(PERSON_B, null), this.selectionChanges);
    }

    @Test
    public void reselect() {
        this.selectionModel.select((Object)PERSON_B);
        this.selectionModel.select((Object)PERSON_C);
        Assert.assertEquals((Object)PERSON_C, this.selectionModel.getSelectedItem().orElse(null));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(Optional.of(PERSON_C), (Object)this.selectionModel.getSelectedItem());
        Assert.assertEquals(Arrays.asList(PERSON_B, PERSON_C), this.selectionChanges);
    }

    @Test
    public void selectTwice() {
        this.selectionModel.select((Object)PERSON_C);
        this.selectionModel.select((Object)PERSON_C);
        Assert.assertEquals((Object)PERSON_C, this.selectionModel.getSelectedItem().orElse(null));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertTrue((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertEquals(Optional.of(PERSON_C), (Object)this.selectionModel.getSelectedItem());
        Assert.assertEquals(Arrays.asList(PERSON_C), this.selectionChanges);
    }

    @Test
    public void deselectTwice() {
        this.selectionModel.select((Object)PERSON_C);
        this.selectionModel.deselect((Object)PERSON_C);
        this.selectionModel.deselect((Object)PERSON_C);
        Assert.assertFalse((boolean)this.selectionModel.getSelectedItem().isPresent());
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_A));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_B));
        Assert.assertFalse((boolean)this.selectionModel.isSelected((Object)PERSON_C));
        Assert.assertFalse((boolean)this.selectionModel.getSelectedItem().isPresent());
        Assert.assertEquals(Arrays.asList(PERSON_C, null), this.selectionChanges);
    }

    @Test
    public void getSelectedItem() {
        this.selectionModel.setSelectedItem((Object)PERSON_B);
        Assert.assertEquals((Object)PERSON_B, this.selectionModel.getSelectedItem().get());
        this.selectionModel.deselect((Object)PERSON_B);
        Assert.assertFalse((boolean)this.selectionModel.getSelectedItem().isPresent());
    }

    @Test
    public void select_deselect_getSelectedItem() {
        this.selectionModel.select((Object)PERSON_C);
        Assert.assertEquals((Object)PERSON_C, this.selectionModel.getSelectedItem().get());
        this.selectionModel.deselect((Object)PERSON_C);
        Assert.assertFalse((boolean)this.selectionModel.getSelectedItem().isPresent());
    }

    @Test
    public void addValueChangeListener() {
        final AtomicReference selectionListener = new AtomicReference();
        final Registration registration = (Registration)Mockito.mock(Registration.class);
        Grid grid = new Grid();
        grid.setItems((Object[])new String[]{"foo", "bar"});
        final String value = "foo";
        SingleSelectionModelImpl<String> select = new SingleSelectionModelImpl<String>(){

            public Registration addSingleSelectionListener(SingleSelectionListener<String> listener) {
                selectionListener.set(listener);
                return registration;
            }

            public Optional<String> getSelectedItem() {
                return Optional.of(value);
            }
        };
        AtomicReference event = new AtomicReference();
        Registration actualRegistration = select.addSingleSelectionListener((SingleSelectionListener & Serializable)evt -> {
            Assert.assertNull(event.get());
            event.set(evt);
        });
        Assert.assertSame((Object)registration, (Object)actualRegistration);
        ((SingleSelectionListener)selectionListener.get()).selectionChange(new SingleSelectionEvent((Component)grid, select.asSingleSelect(), null, true));
        Assert.assertEquals((Object)grid, (Object)((HasValue.ValueChangeEvent)event.get()).getComponent());
        Assert.assertEquals((Object)value, (Object)((HasValue.ValueChangeEvent)event.get()).getValue());
        Assert.assertEquals(null, (Object)((HasValue.ValueChangeEvent)event.get()).getOldValue());
        Assert.assertTrue((boolean)((HasValue.ValueChangeEvent)event.get()).isUserOriginated());
    }

    private static class TestSingleSelectionModel
    extends SingleSelectionModelImpl<Object> {
        public TestSingleSelectionModel() {
            this.getState((boolean)false).selectionAllowed = false;
        }

        protected void setSelectedFromClient(String key) {
            super.setSelectedFromClient(key);
        }
    }

    public static class CustomSingleSelectionModel
    extends SingleSelectionModelImpl<String> {
        public final Map<String, Boolean> generatedData = new LinkedHashMap<String, Boolean>();

        public void generateData(String item, JsonObject jsonObject) {
            super.generateData((Object)item, jsonObject);
            this.generatedData.put(item, this.isSelected(item));
        }
    }
}

