/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.components.grid;

import com.vaadin.data.ValueProvider;
import com.vaadin.server.VaadinSession;
import com.vaadin.tests.util.MockUI;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import java.io.Serializable;
import org.junit.Before;
import org.junit.Test;

public class GridNullValueSortTest {
    private Grid<TestClass> grid;
    private Grid.Column<TestClass, String> stringColumn;
    private Grid.Column<TestClass, Object> nonComparableColumn;

    @Test
    public void sortWithNullValues() {
        this.grid.sort(this.stringColumn);
        this.grid.sort(this.nonComparableColumn);
        this.grid.getDataCommunicator().beforeClientResponse(true);
    }

    @Before
    public void setup() {
        VaadinSession.setCurrent(null);
        this.grid = new Grid();
        this.stringColumn = this.grid.addColumn((ValueProvider & Serializable)bean -> ((TestClass)bean).stringField);
        this.nonComparableColumn = this.grid.addColumn((ValueProvider & Serializable)bean -> ((TestClass)bean).nonComparableField);
        this.grid.setItems((Object[])new TestClass[]{new TestClass(null, new Object()), new TestClass("something", null)});
        new MockUI().setContent((Component)this.grid);
    }

    private static class TestClass {
        private final String stringField;
        private final Object nonComparableField;

        TestClass(String stringField, Object nonComparableField) {
            this.stringField = stringField;
            this.nonComparableField = nonComparableField;
        }
    }
}

