/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.components.grid;

import com.vaadin.data.ValueProvider;
import com.vaadin.server.SerializableComparator;
import com.vaadin.server.VaadinSession;
import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.ui.Grid;
import com.vaadin.ui.renderers.AbstractRenderer;
import com.vaadin.ui.renderers.NumberRenderer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GridNullValueSort {
    private TestGrid grid;

    private static AbstractRenderer<Integer, Boolean> booleanRenderer() {
        return new AbstractRenderer<Integer, Boolean>(Boolean.class){};
    }

    @Before
    public void setup() {
        VaadinSession.setCurrent(null);
        this.grid = new TestGrid();
        this.grid.addColumn((ValueProvider & Serializable)i -> i, (AbstractRenderer)new NumberRenderer()).setId("int").setSortable(true);
        this.grid.addColumn((ValueProvider & Serializable)i -> i == null ? null : String.valueOf(i)).setId("String").setSortable(true);
        this.grid.addColumn((ValueProvider & Serializable)i -> i == null ? null : Boolean.valueOf(i != 1), GridNullValueSort.booleanRenderer()).setId("Boolean").setSortable(true);
    }

    @Test
    public void testNumbersNotNulls() {
        this.grid.sort(this.grid.getColumn("int"), SortDirection.ASCENDING);
        this.performSort(Arrays.asList(2, 1, 3), Arrays.asList(1, 2, 3));
    }

    @Test
    public void testSortByColumnId() {
        this.grid.sort("int");
        this.performSort(Arrays.asList(2, 1, 3), Arrays.asList(1, 2, 3));
    }

    @Test
    public void testSortByColumnIdAndDirection() {
        this.grid.sort("int", SortDirection.DESCENDING);
        this.performSort(Arrays.asList(2, 1, 3), Arrays.asList(3, 2, 1));
    }

    @Test(expected=IllegalStateException.class)
    public void testSortByMissingColumnId() {
        this.grid.sort("notHere");
    }

    @Test(expected=IllegalStateException.class)
    public void testSortByMissingColumnIdAndDirection() {
        this.grid.sort("notHere", SortDirection.DESCENDING);
    }

    @Test
    public void testNumbers() {
        this.grid.sort(this.grid.getColumn("int"), SortDirection.ASCENDING);
        this.performSort(Arrays.asList(1, 2, null, 3, null, null), Arrays.asList(1, 2, 3, null, null, null));
    }

    @Test
    public void testNumbersNotNullsDescending() {
        this.grid.sort(this.grid.getColumn("int"), SortDirection.DESCENDING);
        this.performSort(Arrays.asList(1, 2, 3), Arrays.asList(3, 2, 1));
    }

    @Test
    public void testNumbersDescending() {
        this.grid.sort(this.grid.getColumn("int"), SortDirection.DESCENDING);
        this.performSort(Arrays.asList(1, 3, null, null, null, 2), Arrays.asList(null, null, null, 3, 2, 1));
    }

    @Test
    public void testStringsNotNulls() {
        this.grid.sort(this.grid.getColumn("String"), SortDirection.ASCENDING);
        this.performSort(Arrays.asList(2, 1, 3), Arrays.asList(1, 2, 3));
    }

    @Test
    public void testStrings() {
        this.grid.sort(this.grid.getColumn("String"), SortDirection.ASCENDING);
        this.performSort(Arrays.asList(1, 2, null, 3, null, null), Arrays.asList(1, 2, 3, null, null, null));
    }

    @Test
    public void testStringsNotNullsDescending() {
        this.grid.sort(this.grid.getColumn("String"), SortDirection.DESCENDING);
        this.performSort(Arrays.asList(1, 2, 3), Arrays.asList(3, 2, 1));
    }

    @Test
    public void testStringsDescending() {
        this.grid.sort(this.grid.getColumn("String"), SortDirection.DESCENDING);
        this.performSort(Arrays.asList(1, 3, null, null, null, 2), Arrays.asList(null, null, null, 3, 2, 1));
    }

    @Test
    public void testBooleansNotNulls() {
        this.grid.sort(this.grid.getColumn("Boolean"), SortDirection.ASCENDING);
        this.performSort(Arrays.asList(2, 1), Arrays.asList(1, 2));
    }

    @Test
    public void testBooleans() {
        this.grid.sort(this.grid.getColumn("Boolean"), SortDirection.ASCENDING);
        this.performSort(Arrays.asList(1, null, 2, null, null), Arrays.asList(1, 2, null, null, null));
    }

    @Test
    public void testBooleansNotNullsDescending() {
        this.grid.sort(this.grid.getColumn("Boolean"), SortDirection.DESCENDING);
        this.performSort(Arrays.asList(1, 2), Arrays.asList(2, 1));
    }

    @Test
    public void testBooleansDescending() {
        this.grid.sort(this.grid.getColumn("Boolean"), SortDirection.DESCENDING);
        this.performSort(Arrays.asList(1, null, null, null, 2), Arrays.asList(null, null, null, 2, 1));
    }

    private void performSort(List<Integer> source, List<Integer> expected) {
        SerializableComparator<Integer> sortingComparator = this.grid.createSortingComparator();
        ArrayList<Integer> data = new ArrayList<Integer>(source);
        data.sort((Comparator<Integer>)sortingComparator);
        Assert.assertEquals(expected, data);
    }

    private static class TestGrid
    extends Grid<Integer> {
        private TestGrid() {
        }

        public SerializableComparator<Integer> createSortingComparator() {
            return super.createSortingComparator();
        }
    }
}

