/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.components.grid;

import com.vaadin.data.provider.bov.Person;
import com.vaadin.ui.Grid;
import com.vaadin.ui.components.grid.GridSelectionModel;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GridNoSelectionModelTest {
    public static final Person PERSON_C = new Person("c", 3);
    public static final Person PERSON_B = new Person("b", 2);
    public static final Person PERSON_A = new Person("a", 1);
    private Grid<Person> grid;
    private GridSelectionModel<Person> model;

    @Before
    public void setUp() {
        this.grid = new Grid();
        this.grid.setItems((Object[])new Person[]{PERSON_A, PERSON_B, PERSON_C});
        this.model = this.grid.setSelectionMode(Grid.SelectionMode.NONE);
    }

    @Test
    public void select() {
        this.model.select((Object)PERSON_A);
        Assert.assertFalse((boolean)this.model.isSelected((Object)PERSON_A));
        Assert.assertEquals((long)0L, (long)this.model.getSelectedItems().size());
        Assert.assertEquals(Optional.empty(), (Object)this.model.getFirstSelectedItem());
        this.model.select((Object)PERSON_B);
        Assert.assertFalse((boolean)this.model.isSelected((Object)PERSON_B));
        Assert.assertEquals((long)0L, (long)this.model.getSelectedItems().size());
        Assert.assertEquals(Optional.empty(), (Object)this.model.getFirstSelectedItem());
    }

    @Test
    public void changingToSingleSelectionModel() {
        this.grid.setSelectionMode(Grid.SelectionMode.SINGLE);
        this.grid.getSelectionModel().select((Object)PERSON_B);
        Assert.assertEquals((Object)PERSON_B, this.grid.getSelectionModel().getFirstSelectedItem().get());
    }

    @Test
    public void changingToMultiSelectionModel() {
        this.grid.setSelectionMode(Grid.SelectionMode.MULTI);
        this.grid.getSelectionModel().select((Object)PERSON_B);
        Assert.assertEquals(new LinkedHashSet<Person>(Arrays.asList(PERSON_B)), (Object)this.grid.getSelectionModel().getSelectedItems());
    }
}

