/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests.components;

import com.vaadin.data.TreeData;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.TreeDataProvider;
import com.vaadin.event.CollapseEvent;
import com.vaadin.event.ExpandEvent;
import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.ui.Tree;
import org.junit.Assert;
import org.junit.Test;

public class TreeTest {
    public static final String TEST_CAPTION = "test caption";
    public static final String TEST_DESCRIPTION = "test description";
    public static final String TEST_RESOURCE_ID = "nothing.gif";

    @Test
    public void event_source_is_tree() {
        Tree tree = new Tree();
        TreeData treeData = new TreeData();
        treeData.addItem(null, (Object)"Foo");
        treeData.addItem((Object)"Foo", (Object)"Bar");
        treeData.addItem((Object)"Foo", (Object)"Baz");
        tree.setDataProvider((DataProvider)new TreeDataProvider(treeData));
        TreeCollapseExpandListener listener = new TreeCollapseExpandListener((Tree<String>)tree);
        tree.addExpandListener((ExpandEvent.ExpandListener)listener);
        tree.addCollapseListener((CollapseEvent.CollapseListener)listener);
        Assert.assertFalse((boolean)listener.isExpanded());
        tree.expand((Object[])new String[]{"Foo"});
        Assert.assertTrue((String)"Item not expanded", (boolean)tree.isExpanded((Object)"Foo"));
        Assert.assertTrue((String)"Expand event not fired", (boolean)listener.isExpanded());
        Assert.assertFalse((boolean)listener.isCollapsed());
        tree.collapse((Object[])new String[]{"Foo"});
        Assert.assertFalse((String)"Item not collapsed", (boolean)tree.isExpanded((Object)"Foo"));
        Assert.assertTrue((String)"Collapse event not fired", (boolean)listener.isCollapsed());
    }

    @Test
    public void testComponentProperties() {
        Tree tree = new Tree();
        tree.setCaption(TEST_CAPTION);
        tree.setDescription(TEST_DESCRIPTION);
        tree.setIcon((Resource)new ThemeResource(TEST_RESOURCE_ID));
        Assert.assertEquals((Object)TEST_CAPTION, (Object)tree.getCaption());
        Assert.assertEquals((Object)TEST_DESCRIPTION, (Object)tree.getDescription());
        Assert.assertEquals((Object)TEST_RESOURCE_ID, (Object)tree.getIcon().toString());
        Assert.assertFalse((boolean)tree.isCaptionAsHtml());
        tree.setCaptionAsHtml(true);
        Assert.assertTrue((boolean)tree.isCaptionAsHtml());
    }

    private static class TreeCollapseExpandListener
    implements ExpandEvent.ExpandListener<String>,
    CollapseEvent.CollapseListener<String> {
        private boolean collapsed = false;
        private boolean expanded = false;
        private final Tree<String> tree;

        public TreeCollapseExpandListener(Tree<String> tree) {
            this.tree = tree;
        }

        public void itemCollapse(CollapseEvent<String> event) {
            Assert.assertEquals((String)"Source component was incorrect", this.tree, (Object)event.getComponent());
            Assert.assertFalse((String)"Multiple collapse events", (boolean)this.collapsed);
            this.collapsed = true;
        }

        public void itemExpand(ExpandEvent<String> event) {
            Assert.assertEquals((String)"Source component was incorrect", this.tree, (Object)event.getComponent());
            Assert.assertFalse((String)"Multiple expand events", (boolean)this.expanded);
            this.expanded = true;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public boolean isCollapsed() {
            return this.collapsed;
        }
    }
}

