/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.tests;

import com.vaadin.data.ValueProvider;
import com.vaadin.server.SerializableSupplier;
import com.vaadin.ui.Grid;
import com.vaadin.ui.renderers.AbstractRenderer;
import com.vaadin.ui.renderers.LocalDateRenderer;
import com.vaadin.ui.renderers.LocalDateTimeRenderer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import javax.swing.text.DateFormatter;
import junit.framework.TestCase;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.Test;

public class TestTemporalSerialization {
    @Test
    public void smokeTestRendererSerialization() throws IOException, ClassNotFoundException {
        Grid grid = new Grid();
        grid.addColumn((ValueProvider & Serializable)o -> new Date(o.hashCode()).toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), (AbstractRenderer)new LocalDateRenderer());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(grid);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        Grid readGrid = (Grid)new ObjectInputStream(inputStream).readObject();
        TestCase.assertNotNull(readGrid.getColumns().get(0));
    }

    @Test
    public void testLocalDateRenderer() throws IllegalAccessException, InstantiationException, InvocationTargetException {
        this.testSerialization(LocalDateRenderer.class);
    }

    @Test
    public void testLocalDateTimeRenderer() throws IllegalAccessException, InstantiationException, InvocationTargetException {
        this.testSerialization(LocalDateTimeRenderer.class);
    }

    @Test(expected=AssertionError.class)
    public void testAssertionFail() {
        new LocalDateRenderer((SerializableSupplier)new NonSerializableThing());
    }

    private void testSerialization(Class<?> rendererClass) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Object o;
        Object[] params;
        for (Constructor<?> constructor : rendererClass.getConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers()) || (params = this.simulateParams(constructor)) == null) continue;
            o = constructor.newInstance(params);
            this.checkSerialization(constructor, o);
        }
        for (Executable executable : rendererClass.getMethods()) {
            if (!Modifier.isPublic(((Method)executable).getModifiers()) || !Modifier.isStatic(((Method)executable).getModifiers()) || !((Method)executable).getReturnType().isAssignableFrom(rendererClass) || (params = this.simulateParams(executable)) == null) continue;
            o = ((Method)executable).invoke(this.simulateParams(executable), new Object[0]);
            this.checkSerialization(executable, o);
        }
    }

    private Object[] simulateParams(Executable executable) {
        Parameter[] parameters = executable.getParameters();
        Object[] args = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            Class<Object> type = parameter.getType();
            if (type.isAssignableFrom(String.class)) {
                args[i] = "";
                continue;
            }
            if (type.isAssignableFrom(Locale.class)) {
                args[i] = Locale.US;
                continue;
            }
            if (type.isAssignableFrom(SerializableSupplier.class)) {
                Type genericType = ((ParameterizedType)parameter.getParameterizedType()).getActualTypeArguments()[0];
                args[i] = (SerializableSupplier & Serializable)() -> {
                    try {
                        return ((Class)genericType).newInstance();
                    }
                    catch (Exception e) {
                        throw new AssertionError((Object)e);
                    }
                };
                continue;
            }
            if (type.isAssignableFrom(DateFormatter.class) || type.isAssignableFrom(DateTimeFormatter.class)) {
                TestCase.assertNotNull((String)("Non-deprecated code has non-serializable parameter: " + executable.toGenericString()), (Object)executable.getAnnotation(Deprecated.class));
                return null;
            }
            throw new IllegalArgumentException("Unsupported parameter type: " + type.getName());
        }
        return args;
    }

    private void checkSerialization(Executable method, Object o) {
        try {
            byte[] serialize = SerializationUtils.serialize((Serializable)((Serializable)o));
            SerializationUtils.deserialize((byte[])serialize);
        }
        catch (Throwable e) {
            throw new AssertionError(method.toGenericString(), e);
        }
    }

    private static class NonSerializableThing
    implements SerializableSupplier<DateTimeFormatter> {
        private DateTimeFormatter useless = DateTimeFormatter.ofPattern("Y");

        public DateTimeFormatter get() {
            return this.useless;
        }
    }
}

