/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.server.DefaultUIProvider;
import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.MockServletConfig;
import com.vaadin.server.MockUIContainingServlet;
import com.vaadin.server.TestServlet;
import com.vaadin.server.UIClassSelectionEvent;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinServletRequest;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class VaadinServletConfigurationTest {
    @Test
    public void testEnclosingUIClass() throws Exception {
        MockUIContainingServlet.ServletInUI servlet = new MockUIContainingServlet.ServletInUI();
        servlet.init(new MockServletConfig());
        Class uiClass = new DefaultUIProvider().getUIClass(new UIClassSelectionEvent((VaadinRequest)new VaadinServletRequest((HttpServletRequest)EasyMock.createMock(HttpServletRequest.class), servlet.getService())));
        Assert.assertEquals(MockUIContainingServlet.class, (Object)uiClass);
    }

    @Test
    public void testValuesFromAnnotation() throws ServletException {
        TestServlet servlet = new TestServlet();
        servlet.init(new MockServletConfig());
        DeploymentConfiguration configuration = servlet.getService().getDeploymentConfiguration();
        Assert.assertTrue((boolean)configuration.isProductionMode());
        Assert.assertTrue((boolean)configuration.isCloseIdleSessions());
        Assert.assertEquals((long)1234L, (long)configuration.getHeartbeatInterval());
        Assert.assertEquals((long)4321L, (long)configuration.getResourceCacheTime());
        Class uiClass = new DefaultUIProvider().getUIClass(new UIClassSelectionEvent((VaadinRequest)new VaadinServletRequest((HttpServletRequest)EasyMock.createMock(HttpServletRequest.class), servlet.getService())));
        Assert.assertEquals(MockUIContainingServlet.class, (Object)uiClass);
    }

    @Test
    public void testValuesOverriddenForServlet() throws ServletException {
        Properties servletInitParams = new Properties();
        servletInitParams.setProperty("productionMode", "false");
        servletInitParams.setProperty("heartbeatInterval", "1111");
        TestServlet servlet = new TestServlet();
        servlet.init(new MockServletConfig(servletInitParams));
        DeploymentConfiguration configuration = servlet.getService().getDeploymentConfiguration();
        Assert.assertEquals((long)1111L, (long)configuration.getHeartbeatInterval());
        Assert.assertFalse((boolean)configuration.isProductionMode());
        Assert.assertTrue((boolean)configuration.isCloseIdleSessions());
        Assert.assertEquals((long)4321L, (long)configuration.getResourceCacheTime());
        Class uiClass = new DefaultUIProvider().getUIClass(new UIClassSelectionEvent((VaadinRequest)new VaadinServletRequest((HttpServletRequest)EasyMock.createMock(HttpServletRequest.class), servlet.getService())));
        Assert.assertEquals(MockUIContainingServlet.class, (Object)uiClass);
    }
}

