/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.server.MockServletConfig;
import com.vaadin.server.MockVaadinServletService;
import com.vaadin.server.MockVaadinSession;
import com.vaadin.server.ServiceDestroyEvent;
import com.vaadin.server.ServiceDestroyListener;
import com.vaadin.server.ServiceException;
import com.vaadin.server.SessionDestroyEvent;
import com.vaadin.server.SessionDestroyListener;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinServlet;
import com.vaadin.server.VaadinServletService;
import com.vaadin.server.VaadinSession;
import com.vaadin.server.WrappedSession;
import com.vaadin.shared.Registration;
import com.vaadin.util.CurrentInstance;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSessionBindingEvent;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class VaadinServiceTest {
    private String createCriticalNotification(String caption, String message, String details, String url) {
        return VaadinService.createCriticalNotificationJSON((String)caption, (String)message, (String)details, (String)url);
    }

    @Test
    public void testFireSessionDestroy() throws ServletException {
        VaadinService service = VaadinServiceTest.createService();
        TestSessionDestroyListener listener = new TestSessionDestroyListener();
        service.addSessionDestroyListener((SessionDestroyListener)listener);
        MockVaadinSession vaadinSession = new MockVaadinSession(service);
        service.fireSessionDestroy((VaadinSession)vaadinSession);
        Assert.assertEquals((String)"'fireSessionDestroy' method doesn't call 'close' for the session", (long)1L, (long)vaadinSession.getCloseCount());
        vaadinSession.valueUnbound((HttpSessionBindingEvent)EasyMock.createMock(HttpSessionBindingEvent.class));
        Assert.assertEquals((String)"'fireSessionDestroy' method may not call 'close' method for closing session", (long)1L, (long)vaadinSession.getCloseCount());
        Assert.assertEquals((String)"SessionDestroyListeners not called exactly once", (long)1L, (long)listener.callCount);
    }

    @Test
    public void fireSessionDestroy_sessionStateIsSetToClosed() throws ServletException, ServiceException {
        VaadinService service = VaadinServiceTest.createService();
        final AtomicReference stateRef = new AtomicReference();
        MockVaadinSession vaadinSession = new MockVaadinSession(service){

            protected void setState(VaadinSession.State state) {
                stateRef.set(state);
            }
        };
        service.fireSessionDestroy((VaadinSession)vaadinSession);
        Assert.assertEquals((String)"Session state didn't get set to closed,", (Object)VaadinSession.State.CLOSED, stateRef.get());
    }

    @Test
    public void removeFromHttpSession_setExplicitSessionCloseAttribute() throws ServiceException {
        WrappedSession httpSession = (WrappedSession)Mockito.mock(WrappedSession.class);
        final VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        MockVaadinServletService service = new MockVaadinServletService(){

            protected VaadinSession readFromHttpSession(WrappedSession wrappedSession) {
                return session;
            }
        };
        service.init();
        service.removeFromHttpSession(httpSession);
        ((VaadinSession)Mockito.verify((Object)session)).setAttribute(VaadinSession.CLOSE_SESSION_EXPLICITLY, (Object)true);
    }

    @Test
    public void captionIsSetToACriticalNotification() {
        String notification = this.createCriticalNotification("foobar", "message", "details", "url");
        MatcherAssert.assertThat((Object)notification, (Matcher)CoreMatchers.containsString((String)"\"caption\":\"foobar\""));
    }

    @Test
    public void nullCaptionIsSetToACriticalNotification() {
        String notification = this.createCriticalNotification(null, "message", "details", "url");
        MatcherAssert.assertThat((Object)notification, (Matcher)CoreMatchers.containsString((String)"\"caption\":null"));
    }

    @Test
    public void messageWithDetailsIsSetToACriticalNotification() {
        String notification = this.createCriticalNotification("caption", "foo", "bar", "url");
        MatcherAssert.assertThat((Object)notification, (Matcher)CoreMatchers.containsString((String)"\"details\":\"bar\""));
    }

    @Test
    public void nullMessageSentAsNullInACriticalNotification() {
        String notification = this.createCriticalNotification("caption", null, "foobar", "url");
        MatcherAssert.assertThat((Object)notification, (Matcher)CoreMatchers.containsString((String)"\"message\":null"));
    }

    @Test
    public void nullMessageIsSetToACriticalNotification() {
        String notification = this.createCriticalNotification("caption", null, null, "url");
        MatcherAssert.assertThat((Object)notification, (Matcher)CoreMatchers.containsString((String)"\"message\":null"));
    }

    @Test
    public void messageSetToACriticalNotification() {
        String notification = this.createCriticalNotification("caption", "foobar", null, "url");
        MatcherAssert.assertThat((Object)notification, (Matcher)CoreMatchers.containsString((String)"\"message\":\"foobar\""));
    }

    @Test
    public void urlIsSetToACriticalNotification() {
        String notification = this.createCriticalNotification("caption", "message", "details", "foobar");
        MatcherAssert.assertThat((Object)notification, (Matcher)CoreMatchers.containsString((String)"\"url\":\"foobar\""));
    }

    @Test
    public void nullUrlIsSetToACriticalNotification() {
        String notification = this.createCriticalNotification("caption", "message", "details", null);
        MatcherAssert.assertThat((Object)notification, (Matcher)CoreMatchers.containsString((String)"\"url\":null"));
    }

    @Test
    public void currentInstancesAfterPendingAccessTasks() {
        VaadinService service = VaadinServiceTest.createService();
        MockVaadinSession session = new MockVaadinSession(service);
        session.lock();
        service.accessSession((VaadinSession)session, () -> CurrentInstance.set(String.class, (Object)"Set in task"));
        CurrentInstance.set(String.class, (Object)"Original value");
        service.runPendingAccessTasks((VaadinSession)session);
        Assert.assertEquals((String)"Original CurrentInstance should be set after the task has been run", (Object)"Original value", (Object)CurrentInstance.get(String.class));
    }

    private static VaadinService createService() {
        MockServletConfig servletConfig = new MockServletConfig();
        VaadinServlet servlet = new VaadinServlet();
        try {
            servlet.init((ServletConfig)servletConfig);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        VaadinServletService service = servlet.getService();
        return service;
    }

    @Test
    public void fireServiceDestroy() {
        VaadinService service = VaadinServiceTest.createService();
        TestServiceDestroyListener listener = new TestServiceDestroyListener();
        TestServiceDestroyListener listener2 = new TestServiceDestroyListener();
        service.addServiceDestroyListener((ServiceDestroyListener)listener);
        Registration remover2 = service.addServiceDestroyListener((ServiceDestroyListener)listener2);
        service.destroy();
        Assert.assertEquals((long)1L, (long)listener.callCount);
        Assert.assertEquals((long)1L, (long)listener2.callCount);
        service.removeServiceDestroyListener((ServiceDestroyListener)listener);
        remover2.remove();
        service.destroy();
        Assert.assertEquals((long)1L, (long)listener.callCount);
        Assert.assertEquals((long)1L, (long)listener2.callCount);
    }

    @Test
    public void reinitializeSession_setVaadinSessionAttriuteWithLock() {
        VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        VaadinSession vaadinSession = (VaadinSession)Mockito.mock(VaadinSession.class);
        VaadinSession newVaadinSession = (VaadinSession)Mockito.mock(VaadinSession.class);
        WrappedSession session = this.mockSession(request, vaadinSession, "foo");
        ((WrappedSession)Mockito.doAnswer(invocation -> {
            this.mockSession(request, newVaadinSession, "bar");
            return null;
        }).when((Object)session)).invalidate();
        VaadinService.reinitializeSession((VaadinRequest)request);
        ((VaadinSession)Mockito.verify((Object)vaadinSession, (VerificationMode)Mockito.times((int)2))).lock();
        ((VaadinSession)Mockito.verify((Object)vaadinSession)).setAttribute(VaadinService.PRESERVE_UNBOUND_SESSION_ATTRIBUTE, (Object)Boolean.TRUE);
        ((VaadinSession)Mockito.verify((Object)vaadinSession)).setAttribute(VaadinService.PRESERVE_UNBOUND_SESSION_ATTRIBUTE, null);
        ((VaadinSession)Mockito.verify((Object)vaadinSession, (VerificationMode)Mockito.times((int)2))).unlock();
    }

    private WrappedSession mockSession(VaadinRequest request, VaadinSession vaadinSession, String attributeName) {
        WrappedSession session = (WrappedSession)Mockito.mock(WrappedSession.class);
        Mockito.when((Object)request.getWrappedSession()).thenReturn((Object)session);
        Mockito.when((Object)session.getAttributeNames()).thenReturn(Collections.singleton(attributeName));
        Mockito.when((Object)session.getAttribute(attributeName)).thenReturn((Object)vaadinSession);
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        Mockito.when((Object)vaadinSession.getService()).thenReturn((Object)service);
        return session;
    }

    private class TestServiceDestroyListener
    implements ServiceDestroyListener {
        int callCount = 0;

        private TestServiceDestroyListener() {
        }

        public void serviceDestroy(ServiceDestroyEvent event) {
            ++this.callCount;
        }
    }

    private class TestSessionDestroyListener
    implements SessionDestroyListener {
        int callCount = 0;

        private TestSessionDestroyListener() {
        }

        public void sessionDestroy(SessionDestroyEvent event) {
            ++this.callCount;
        }
    }
}

