/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.data.provider.AbstractDataProvider;
import com.vaadin.event.EventRouter;
import com.vaadin.event.MethodEventSource;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.shared.Registration;
import com.vaadin.tests.VaadinClasses;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;

public class RemoveListenersDeprecatedTest {
    private static final List<Predicate<Method>> ALLOW_REMOVE_LISTENER = new ArrayList<Predicate<Method>>();

    @Test
    public void allRemoveListenerMethodsMarkedAsDeprecated() {
        Pattern removePattern = Pattern.compile("remove.*Listener");
        Pattern addPattern = Pattern.compile("add.*Listener");
        int count = 0;
        for (Class<? extends Object> serverClass : VaadinClasses.getAllServerSideClasses()) {
            ++count;
            if (serverClass.equals(EventRouter.class)) continue;
            for (Method method : serverClass.getDeclaredMethods()) {
                if (Modifier.isPrivate(method.getModifiers())) continue;
                if (addPattern.matcher(method.getName()).matches() && method.getAnnotation(Deprecated.class) == null) {
                    Class<?> returnType = method.getReturnType();
                    Assert.assertEquals((String)("Method " + method.getName() + " is not deprectated in class " + serverClass.getName() + " and doesn't return a Registration object"), Registration.class, returnType);
                }
                if (ALLOW_REMOVE_LISTENER.stream().anyMatch(predicate -> predicate.test(method)) || !removePattern.matcher(method.getName()).matches()) continue;
                Assert.assertNotNull((String)("Method " + method.getName() + " in class " + serverClass.getName() + " has not been marked as deprecated."), (Object)method.getAnnotation(Deprecated.class));
            }
        }
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
    }

    private static boolean acceptMethodEventSource(Method method) {
        return method.getDeclaringClass().equals(MethodEventSource.class) && method.getParameterCount() == 2;
    }

    private static boolean acceptAbstarctClientConnectorRemoveMethods(Method method) {
        if (method.getDeclaringClass().equals(AbstractClientConnector.class)) {
            if (method.getParameterCount() == 2) {
                return true;
            }
            if (method.getParameterCount() == 0) {
                return false;
            }
            return method.getParameterTypes()[0].equals(String.class);
        }
        return false;
    }

    private static boolean acceptAbstractDataProvider(Method method) {
        return method.getDeclaringClass().equals(AbstractDataProvider.class) && method.getParameterCount() == 2;
    }

    static {
        ALLOW_REMOVE_LISTENER.add(RemoveListenersDeprecatedTest::acceptAbstarctClientConnectorRemoveMethods);
        ALLOW_REMOVE_LISTENER.add(RemoveListenersDeprecatedTest::acceptAbstractDataProvider);
        ALLOW_REMOVE_LISTENER.add(RemoveListenersDeprecatedTest::acceptMethodEventSource);
    }
}

