/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.server.LocaleService;
import com.vaadin.shared.ui.ui.UIState;
import com.vaadin.ui.UI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class LocaleServiceTest {
    private static Set<String> JAVA8_SUPPORTED_LOCALES = new HashSet<String>();
    private static Map<Locale, UIState.LocaleData> expectedLocaleData;
    private LocaleService localeService;

    @Before
    public void setup() {
        this.localeService = new LocaleService((UI)Mockito.mock(UI.class), new UIState.LocaleServiceState());
    }

    @Test
    public void localeDateTimeFormat() {
        for (Locale l : expectedLocaleData.keySet()) {
            Assert.assertEquals((String)("Error verifying locale " + l), (Object)LocaleServiceTest.expectedLocaleData.get((Object)l).dateFormat, (Object)this.localeService.createLocaleData((Locale)l).dateFormat);
            Assert.assertEquals((String)("Error verifying locale " + l), (Object)LocaleServiceTest.expectedLocaleData.get((Object)l).twelveHourClock, (Object)this.localeService.createLocaleData((Locale)l).twelveHourClock);
            Assert.assertEquals((String)("Error verifying locale " + l), (Object)LocaleServiceTest.expectedLocaleData.get((Object)l).am, (Object)this.localeService.createLocaleData((Locale)l).am);
            Assert.assertEquals((String)("Error verifying locale " + l), (Object)LocaleServiceTest.expectedLocaleData.get((Object)l).pm, (Object)this.localeService.createLocaleData((Locale)l).pm);
        }
    }

    public static void main(String[] args) {
        for (String s : JAVA8_SUPPORTED_LOCALES) {
            Locale l;
            String[] parts = s.split("-", 3);
            if (parts.length == 1) {
                l = new Locale(parts[0]);
            } else if (parts.length == 2) {
                l = new Locale(parts[0], parts[1]);
            } else if (parts.length == 3) {
                l = new Locale(parts[0], parts[1], parts[2]);
            } else {
                throw new RuntimeException("Unexpected locale: " + s);
            }
            LocaleServiceTest.generateData(l);
        }
    }

    private static void generateData(Locale locale) {
        System.out.println();
        String id = locale.getLanguage();
        if (!locale.getCountry().isEmpty()) {
            id = id + "_" + locale.getCountry();
            if (!locale.getVariant().isEmpty()) {
                id = id + "_" + locale.getVariant();
            }
        }
        String field = id.replace('-', '_');
        LocaleService localeService = new LocaleService((UI)Mockito.mock(UI.class), new UIState.LocaleServiceState());
        UIState.LocaleData localeData = localeService.createLocaleData(locale);
        System.out.println("LocaleData " + field + " = new LocaleData();");
        System.out.println(field + ".dateFormat = \"" + localeData.dateFormat + "\";");
        System.out.println(field + ".twelveHourClock = " + localeData.twelveHourClock + ";");
        System.out.println(field + ".hourMinuteDelimiter = \"" + localeData.hourMinuteDelimiter + "\";");
        if (localeData.twelveHourClock) {
            System.out.println(field + ".am = \"" + localeData.am + "\";");
            System.out.println(field + ".pm = \"" + localeData.pm + "\";");
        }
        System.out.println("expectedLocaleData.put(new Locale(\"" + id.replaceAll("_", "\",\"") + "\"), " + field + ");");
    }

    static {
        JAVA8_SUPPORTED_LOCALES.add("sq-AL");
        JAVA8_SUPPORTED_LOCALES.add("ar-DZ");
        JAVA8_SUPPORTED_LOCALES.add("ar-BH");
        JAVA8_SUPPORTED_LOCALES.add("ar-EG");
        JAVA8_SUPPORTED_LOCALES.add("ar-IQ");
        JAVA8_SUPPORTED_LOCALES.add("ar-JO");
        JAVA8_SUPPORTED_LOCALES.add("ar-KW");
        JAVA8_SUPPORTED_LOCALES.add("ar-LB");
        JAVA8_SUPPORTED_LOCALES.add("ar-LY");
        JAVA8_SUPPORTED_LOCALES.add("ar-MA");
        JAVA8_SUPPORTED_LOCALES.add("ar-OM");
        JAVA8_SUPPORTED_LOCALES.add("ar-QA");
        JAVA8_SUPPORTED_LOCALES.add("ar-SA");
        JAVA8_SUPPORTED_LOCALES.add("ar-SD");
        JAVA8_SUPPORTED_LOCALES.add("ar-SY");
        JAVA8_SUPPORTED_LOCALES.add("ar-TN");
        JAVA8_SUPPORTED_LOCALES.add("ar-AE");
        JAVA8_SUPPORTED_LOCALES.add("ar-YE");
        JAVA8_SUPPORTED_LOCALES.add("be-BY");
        JAVA8_SUPPORTED_LOCALES.add("bg-BG");
        JAVA8_SUPPORTED_LOCALES.add("ca-ES");
        JAVA8_SUPPORTED_LOCALES.add("zh-CN");
        JAVA8_SUPPORTED_LOCALES.add("zh-SG");
        JAVA8_SUPPORTED_LOCALES.add("zh-HK");
        JAVA8_SUPPORTED_LOCALES.add("zh-TW");
        JAVA8_SUPPORTED_LOCALES.add("hr-HR");
        JAVA8_SUPPORTED_LOCALES.add("cs-CZ");
        JAVA8_SUPPORTED_LOCALES.add("da-DK");
        JAVA8_SUPPORTED_LOCALES.add("nl-BE");
        JAVA8_SUPPORTED_LOCALES.add("nl-NL");
        JAVA8_SUPPORTED_LOCALES.add("en-AU");
        JAVA8_SUPPORTED_LOCALES.add("en-CA");
        JAVA8_SUPPORTED_LOCALES.add("en-IN");
        JAVA8_SUPPORTED_LOCALES.add("en-IE");
        JAVA8_SUPPORTED_LOCALES.add("en-MT");
        JAVA8_SUPPORTED_LOCALES.add("en-NZ");
        JAVA8_SUPPORTED_LOCALES.add("en-PH");
        JAVA8_SUPPORTED_LOCALES.add("en-SG");
        JAVA8_SUPPORTED_LOCALES.add("en-ZA");
        JAVA8_SUPPORTED_LOCALES.add("en-GB");
        JAVA8_SUPPORTED_LOCALES.add("en-US");
        JAVA8_SUPPORTED_LOCALES.add("et-EE");
        JAVA8_SUPPORTED_LOCALES.add("fi-FI");
        JAVA8_SUPPORTED_LOCALES.add("fr-BE");
        JAVA8_SUPPORTED_LOCALES.add("fr-CA");
        JAVA8_SUPPORTED_LOCALES.add("fr-FR");
        JAVA8_SUPPORTED_LOCALES.add("fr-LU");
        JAVA8_SUPPORTED_LOCALES.add("fr-CH");
        JAVA8_SUPPORTED_LOCALES.add("de-AT");
        JAVA8_SUPPORTED_LOCALES.add("de-DE");
        JAVA8_SUPPORTED_LOCALES.add("de-LU");
        JAVA8_SUPPORTED_LOCALES.add("de-CH");
        JAVA8_SUPPORTED_LOCALES.add("el-CY");
        JAVA8_SUPPORTED_LOCALES.add("el-GR");
        JAVA8_SUPPORTED_LOCALES.add("iw-IL");
        JAVA8_SUPPORTED_LOCALES.add("hi-IN");
        JAVA8_SUPPORTED_LOCALES.add("hu-HU");
        JAVA8_SUPPORTED_LOCALES.add("is-IS");
        JAVA8_SUPPORTED_LOCALES.add("in-ID");
        JAVA8_SUPPORTED_LOCALES.add("ga-IE");
        JAVA8_SUPPORTED_LOCALES.add("it-IT");
        JAVA8_SUPPORTED_LOCALES.add("it-CH");
        JAVA8_SUPPORTED_LOCALES.add("ja-JP");
        JAVA8_SUPPORTED_LOCALES.add("ja-JP-u-ca-japanese");
        JAVA8_SUPPORTED_LOCALES.add("ja-JP-x-lvariant-JP");
        JAVA8_SUPPORTED_LOCALES.add("ko-KR");
        JAVA8_SUPPORTED_LOCALES.add("lv-LV");
        JAVA8_SUPPORTED_LOCALES.add("lt-LT");
        JAVA8_SUPPORTED_LOCALES.add("mk-MK");
        JAVA8_SUPPORTED_LOCALES.add("ms-MY");
        JAVA8_SUPPORTED_LOCALES.add("mt-MT");
        JAVA8_SUPPORTED_LOCALES.add("no-NO");
        JAVA8_SUPPORTED_LOCALES.add("nb-NO");
        JAVA8_SUPPORTED_LOCALES.add("nn-NO");
        JAVA8_SUPPORTED_LOCALES.add("no-NO-x-lvariant-NY");
        JAVA8_SUPPORTED_LOCALES.add("pl-PL");
        JAVA8_SUPPORTED_LOCALES.add("pt-BR");
        JAVA8_SUPPORTED_LOCALES.add("pt-PT");
        JAVA8_SUPPORTED_LOCALES.add("ro-RO");
        JAVA8_SUPPORTED_LOCALES.add("ru-RU");
        JAVA8_SUPPORTED_LOCALES.add("sr-BA");
        JAVA8_SUPPORTED_LOCALES.add("sr-ME");
        JAVA8_SUPPORTED_LOCALES.add("sr-RS");
        JAVA8_SUPPORTED_LOCALES.add("sr-Latn-BA");
        JAVA8_SUPPORTED_LOCALES.add("sr-Latn-ME");
        JAVA8_SUPPORTED_LOCALES.add("sr-Latn-RS");
        JAVA8_SUPPORTED_LOCALES.add("sk-SK");
        JAVA8_SUPPORTED_LOCALES.add("sl-SI");
        JAVA8_SUPPORTED_LOCALES.add("es-AR");
        JAVA8_SUPPORTED_LOCALES.add("es-BO");
        JAVA8_SUPPORTED_LOCALES.add("es-CL");
        JAVA8_SUPPORTED_LOCALES.add("es-CO");
        JAVA8_SUPPORTED_LOCALES.add("es-CR");
        JAVA8_SUPPORTED_LOCALES.add("es-DO");
        JAVA8_SUPPORTED_LOCALES.add("es-EC");
        JAVA8_SUPPORTED_LOCALES.add("es-SV");
        JAVA8_SUPPORTED_LOCALES.add("es-GT");
        JAVA8_SUPPORTED_LOCALES.add("es-HN");
        JAVA8_SUPPORTED_LOCALES.add("es-MX");
        JAVA8_SUPPORTED_LOCALES.add("es-NI");
        JAVA8_SUPPORTED_LOCALES.add("es-PA");
        JAVA8_SUPPORTED_LOCALES.add("es-PY");
        JAVA8_SUPPORTED_LOCALES.add("es-PE");
        JAVA8_SUPPORTED_LOCALES.add("es-PR");
        JAVA8_SUPPORTED_LOCALES.add("es-ES");
        JAVA8_SUPPORTED_LOCALES.add("es-US");
        JAVA8_SUPPORTED_LOCALES.add("es-UY");
        JAVA8_SUPPORTED_LOCALES.add("es-VE");
        JAVA8_SUPPORTED_LOCALES.add("sv-SE");
        JAVA8_SUPPORTED_LOCALES.add("th-TH");
        JAVA8_SUPPORTED_LOCALES.add("th-TH-u-ca-buddhist");
        JAVA8_SUPPORTED_LOCALES.add("th-TH-u-ca-buddhist-nu-thai");
        JAVA8_SUPPORTED_LOCALES.add("th-TH-x-lvariant-TH");
        JAVA8_SUPPORTED_LOCALES.add("tr-TR");
        JAVA8_SUPPORTED_LOCALES.add("uk-UA");
        JAVA8_SUPPORTED_LOCALES.add("vi-VN");
        expectedLocaleData = new HashMap<Locale, UIState.LocaleData>();
        UIState.LocaleData en_IE = new UIState.LocaleData();
        en_IE.dateFormat = "dd/MM/yy";
        en_IE.twelveHourClock = false;
        en_IE.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("en", "IE"), en_IE);
        UIState.LocaleData ar_KW = new UIState.LocaleData();
        ar_KW.dateFormat = "dd/MM/yy";
        ar_KW.twelveHourClock = true;
        ar_KW.hourMinuteDelimiter = ":";
        ar_KW.am = "\u0635";
        ar_KW.pm = "\u0645";
        expectedLocaleData.put(new Locale("ar", "KW"), ar_KW);
        UIState.LocaleData ms_MY = new UIState.LocaleData();
        ms_MY.dateFormat = "dd/MM/yyyy";
        ms_MY.twelveHourClock = false;
        ms_MY.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("ms", "MY"), ms_MY);
        UIState.LocaleData en_IN = new UIState.LocaleData();
        en_IN.dateFormat = "d/M/yy";
        en_IN.twelveHourClock = true;
        en_IN.hourMinuteDelimiter = ":";
        en_IN.am = "AM";
        en_IN.pm = "PM";
        expectedLocaleData.put(new Locale("en", "IN"), en_IN);
        UIState.LocaleData es_BO = new UIState.LocaleData();
        es_BO.dateFormat = "dd-MM-yy";
        es_BO.twelveHourClock = true;
        es_BO.hourMinuteDelimiter = ":";
        es_BO.am = "AM";
        es_BO.pm = "PM";
        expectedLocaleData.put(new Locale("es", "BO"), es_BO);
        UIState.LocaleData ar_SY = new UIState.LocaleData();
        ar_SY.dateFormat = "dd/MM/yy";
        ar_SY.twelveHourClock = true;
        ar_SY.hourMinuteDelimiter = ":";
        ar_SY.am = "\u0635";
        ar_SY.pm = "\u0645";
        expectedLocaleData.put(new Locale("ar", "SY"), ar_SY);
        UIState.LocaleData en_ZA = new UIState.LocaleData();
        en_ZA.dateFormat = "yyyy/MM/dd";
        en_ZA.twelveHourClock = true;
        en_ZA.hourMinuteDelimiter = ":";
        en_ZA.am = "AM";
        en_ZA.pm = "PM";
        expectedLocaleData.put(new Locale("en", "ZA"), en_ZA);
        UIState.LocaleData no_NO = new UIState.LocaleData();
        no_NO.dateFormat = "dd.MM.yy";
        no_NO.twelveHourClock = false;
        no_NO.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("no", "NO"), no_NO);
        UIState.LocaleData sr_LATN_BA = new UIState.LocaleData();
        sr_LATN_BA.dateFormat = "d.M.yy.";
        sr_LATN_BA.twelveHourClock = false;
        sr_LATN_BA.hourMinuteDelimiter = ".";
        expectedLocaleData.put(new Locale("sr", "LATN", "BA"), sr_LATN_BA);
        UIState.LocaleData el_GR = new UIState.LocaleData();
        el_GR.dateFormat = "d/M/yyyy";
        el_GR.twelveHourClock = true;
        el_GR.hourMinuteDelimiter = ":";
        el_GR.am = "\u03c0\u03bc";
        el_GR.pm = "\u03bc\u03bc";
        expectedLocaleData.put(new Locale("el", "GR"), el_GR);
        UIState.LocaleData sr_LATN_RS = new UIState.LocaleData();
        sr_LATN_RS.dateFormat = "d.M.yy.";
        sr_LATN_RS.twelveHourClock = false;
        sr_LATN_RS.hourMinuteDelimiter = ".";
        expectedLocaleData.put(new Locale("sr", "LATN", "RS"), sr_LATN_RS);
        UIState.LocaleData nl_NL = new UIState.LocaleData();
        nl_NL.dateFormat = "d-M-yy";
        nl_NL.twelveHourClock = false;
        nl_NL.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("nl", "NL"), nl_NL);
        UIState.LocaleData ar_LB = new UIState.LocaleData();
        ar_LB.dateFormat = "dd/MM/yy";
        ar_LB.twelveHourClock = true;
        ar_LB.hourMinuteDelimiter = ":";
        ar_LB.am = "\u0635";
        ar_LB.pm = "\u0645";
        expectedLocaleData.put(new Locale("ar", "LB"), ar_LB);
        UIState.LocaleData en_AU = new UIState.LocaleData();
        en_AU.dateFormat = "d/MM/yy";
        en_AU.twelveHourClock = true;
        en_AU.hourMinuteDelimiter = ":";
        en_AU.am = "AM";
        en_AU.pm = "PM";
        expectedLocaleData.put(new Locale("en", "AU"), en_AU);
        UIState.LocaleData mk_MK = new UIState.LocaleData();
        mk_MK.dateFormat = "d.M.yy";
        mk_MK.twelveHourClock = false;
        mk_MK.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("mk", "MK"), mk_MK);
        UIState.LocaleData ar_TN = new UIState.LocaleData();
        ar_TN.dateFormat = "dd/MM/yy";
        ar_TN.twelveHourClock = true;
        ar_TN.hourMinuteDelimiter = ":";
        ar_TN.am = "\u0635";
        ar_TN.pm = "\u0645";
        expectedLocaleData.put(new Locale("ar", "TN"), ar_TN);
        UIState.LocaleData ar_LY = new UIState.LocaleData();
        ar_LY.dateFormat = "dd/MM/yy";
        ar_LY.twelveHourClock = true;
        ar_LY.hourMinuteDelimiter = ":";
        ar_LY.am = "\u0635";
        ar_LY.pm = "\u0645";
        expectedLocaleData.put(new Locale("ar", "LY"), ar_LY);
        UIState.LocaleData hu_HU = new UIState.LocaleData();
        hu_HU.dateFormat = "yyyy.MM.dd.";
        hu_HU.twelveHourClock = false;
        hu_HU.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("hu", "HU"), hu_HU);
        UIState.LocaleData es_SV = new UIState.LocaleData();
        es_SV.dateFormat = "MM-dd-yy";
        es_SV.twelveHourClock = true;
        es_SV.hourMinuteDelimiter = ":";
        es_SV.am = "AM";
        es_SV.pm = "PM";
        expectedLocaleData.put(new Locale("es", "SV"), es_SV);
        UIState.LocaleData es_CR = new UIState.LocaleData();
        es_CR.dateFormat = "dd/MM/yy";
        es_CR.twelveHourClock = true;
        es_CR.hourMinuteDelimiter = ":";
        es_CR.am = "AM";
        es_CR.pm = "PM";
        expectedLocaleData.put(new Locale("es", "CR"), es_CR);
        UIState.LocaleData es_CL = new UIState.LocaleData();
        es_CL.dateFormat = "dd-MM-yy";
        es_CL.twelveHourClock = false;
        es_CL.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("es", "CL"), es_CL);
        UIState.LocaleData fr_CA = new UIState.LocaleData();
        fr_CA.dateFormat = "yy-MM-dd";
        fr_CA.twelveHourClock = false;
        fr_CA.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("fr", "CA"), fr_CA);
        UIState.LocaleData es_CO = new UIState.LocaleData();
        es_CO.dateFormat = "d/MM/yy";
        es_CO.twelveHourClock = true;
        es_CO.hourMinuteDelimiter = ":";
        es_CO.am = "AM";
        es_CO.pm = "PM";
        expectedLocaleData.put(new Locale("es", "CO"), es_CO);
        UIState.LocaleData pl_PL = new UIState.LocaleData();
        pl_PL.dateFormat = "dd.MM.yy";
        pl_PL.twelveHourClock = false;
        pl_PL.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("pl", "PL"), pl_PL);
        UIState.LocaleData pt_PT = new UIState.LocaleData();
        pt_PT.dateFormat = "dd-MM-yyyy";
        pt_PT.twelveHourClock = false;
        pt_PT.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("pt", "PT"), pt_PT);
        UIState.LocaleData ar_EG = new UIState.LocaleData();
        ar_EG.dateFormat = "dd/MM/yy";
        ar_EG.twelveHourClock = true;
        ar_EG.hourMinuteDelimiter = ":";
        ar_EG.am = "\u0635";
        ar_EG.pm = "\u0645";
        expectedLocaleData.put(new Locale("ar", "EG"), ar_EG);
        UIState.LocaleData fr_BE = new UIState.LocaleData();
        fr_BE.dateFormat = "d/MM/yy";
        fr_BE.twelveHourClock = false;
        fr_BE.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("fr", "BE"), fr_BE);
        UIState.LocaleData ga_IE = new UIState.LocaleData();
        ga_IE.dateFormat = "dd/MM/yyyy";
        ga_IE.twelveHourClock = false;
        ga_IE.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("ga", "IE"), ga_IE);
        UIState.LocaleData ar_DZ = new UIState.LocaleData();
        ar_DZ.dateFormat = "dd/MM/yy";
        ar_DZ.twelveHourClock = true;
        ar_DZ.hourMinuteDelimiter = ":";
        ar_DZ.am = "\u0635";
        ar_DZ.pm = "\u0645";
        expectedLocaleData.put(new Locale("ar", "DZ"), ar_DZ);
        UIState.LocaleData en_SG = new UIState.LocaleData();
        en_SG.dateFormat = "d/M/yy";
        en_SG.twelveHourClock = true;
        en_SG.hourMinuteDelimiter = ":";
        en_SG.am = "AM";
        en_SG.pm = "PM";
        expectedLocaleData.put(new Locale("en", "SG"), en_SG);
        UIState.LocaleData in_ID = new UIState.LocaleData();
        in_ID.dateFormat = "dd/MM/yy";
        in_ID.twelveHourClock = false;
        in_ID.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("in", "ID"), in_ID);
        UIState.LocaleData ar_MA = new UIState.LocaleData();
        ar_MA.dateFormat = "dd/MM/yy";
        ar_MA.twelveHourClock = true;
        ar_MA.hourMinuteDelimiter = ":";
        ar_MA.am = "\u0635";
        ar_MA.pm = "\u0645";
        expectedLocaleData.put(new Locale("ar", "MA"), ar_MA);
        UIState.LocaleData th_TH_u_ca_buddhist_nu_thai = new UIState.LocaleData();
        th_TH_u_ca_buddhist_nu_thai.dateFormat = "d/M/yyyy";
        th_TH_u_ca_buddhist_nu_thai.twelveHourClock = false;
        th_TH_u_ca_buddhist_nu_thai.hourMinuteDelimiter = ".";
        expectedLocaleData.put(new Locale("th", "TH", "u-ca-buddhist-nu-thai"), th_TH_u_ca_buddhist_nu_thai);
        UIState.LocaleData nb_NO = new UIState.LocaleData();
        nb_NO.dateFormat = "dd.MM.yy";
        nb_NO.twelveHourClock = false;
        nb_NO.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("nb", "NO"), nb_NO);
        UIState.LocaleData es_HN = new UIState.LocaleData();
        es_HN.dateFormat = "MM-dd-yy";
        es_HN.twelveHourClock = true;
        es_HN.hourMinuteDelimiter = ":";
        es_HN.am = "AM";
        es_HN.pm = "PM";
        expectedLocaleData.put(new Locale("es", "HN"), es_HN);
        UIState.LocaleData hr_HR = new UIState.LocaleData();
        hr_HR.dateFormat = "dd.MM.yy.";
        hr_HR.twelveHourClock = false;
        hr_HR.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("hr", "HR"), hr_HR);
        UIState.LocaleData es_PR = new UIState.LocaleData();
        es_PR.dateFormat = "MM-dd-yy";
        es_PR.twelveHourClock = true;
        es_PR.hourMinuteDelimiter = ":";
        es_PR.am = "AM";
        es_PR.pm = "PM";
        expectedLocaleData.put(new Locale("es", "PR"), es_PR);
        UIState.LocaleData es_PY = new UIState.LocaleData();
        es_PY.dateFormat = "dd/MM/yy";
        es_PY.twelveHourClock = true;
        es_PY.hourMinuteDelimiter = ":";
        es_PY.am = "AM";
        es_PY.pm = "PM";
        expectedLocaleData.put(new Locale("es", "PY"), es_PY);
        UIState.LocaleData sr_ME = new UIState.LocaleData();
        sr_ME.dateFormat = "d.M.yy.";
        sr_ME.twelveHourClock = false;
        sr_ME.hourMinuteDelimiter = ".";
        expectedLocaleData.put(new Locale("sr", "ME"), sr_ME);
        UIState.LocaleData de_AT = new UIState.LocaleData();
        de_AT.dateFormat = "dd.MM.yy";
        de_AT.twelveHourClock = false;
        de_AT.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("de", "AT"), de_AT);
        UIState.LocaleData is_IS = new UIState.LocaleData();
        is_IS.dateFormat = "d.M.yyyy";
        is_IS.twelveHourClock = false;
        is_IS.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("is", "IS"), is_IS);
        UIState.LocaleData bg_BG = new UIState.LocaleData();
        bg_BG.dateFormat = "dd.MM.yy";
        bg_BG.twelveHourClock = false;
        bg_BG.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("bg", "BG"), bg_BG);
        UIState.LocaleData cs_CZ = new UIState.LocaleData();
        cs_CZ.dateFormat = "d.M.yy";
        cs_CZ.twelveHourClock = false;
        cs_CZ.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("cs", "CZ"), cs_CZ);
        UIState.LocaleData en_PH = new UIState.LocaleData();
        en_PH.dateFormat = "M/d/yy";
        en_PH.twelveHourClock = true;
        en_PH.hourMinuteDelimiter = ":";
        en_PH.am = "AM";
        en_PH.pm = "PM";
        expectedLocaleData.put(new Locale("en", "PH"), en_PH);
        UIState.LocaleData zh_TW = new UIState.LocaleData();
        zh_TW.dateFormat = "yyyy/M/d";
        zh_TW.twelveHourClock = true;
        zh_TW.hourMinuteDelimiter = ":";
        zh_TW.am = "\u4e0a\u5348";
        zh_TW.pm = "\u4e0b\u5348";
        expectedLocaleData.put(new Locale("zh", "TW"), zh_TW);
        UIState.LocaleData ko_KR = new UIState.LocaleData();
        ko_KR.dateFormat = "yy. M. d";
        ko_KR.twelveHourClock = true;
        ko_KR.hourMinuteDelimiter = ":";
        ko_KR.am = "\uc624\uc804";
        ko_KR.pm = "\uc624\ud6c4";
        expectedLocaleData.put(new Locale("ko", "KR"), ko_KR);
        UIState.LocaleData sk_SK = new UIState.LocaleData();
        sk_SK.dateFormat = "d.M.yyyy";
        sk_SK.twelveHourClock = false;
        sk_SK.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("sk", "SK"), sk_SK);
        UIState.LocaleData sr_LATN_ME = new UIState.LocaleData();
        sr_LATN_ME.dateFormat = "d.M.yy.";
        sr_LATN_ME.twelveHourClock = false;
        sr_LATN_ME.hourMinuteDelimiter = ".";
        expectedLocaleData.put(new Locale("sr", "LATN", "ME"), sr_LATN_ME);
        UIState.LocaleData ar_OM = new UIState.LocaleData();
        ar_OM.dateFormat = "dd/MM/yy";
        ar_OM.twelveHourClock = true;
        ar_OM.hourMinuteDelimiter = ":";
        ar_OM.am = "\u0635";
        ar_OM.pm = "\u0645";
        expectedLocaleData.put(new Locale("ar", "OM"), ar_OM);
        UIState.LocaleData ru_RU = new UIState.LocaleData();
        ru_RU.dateFormat = "dd.MM.yy";
        ru_RU.twelveHourClock = false;
        ru_RU.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("ru", "RU"), ru_RU);
        UIState.LocaleData sq_AL = new UIState.LocaleData();
        sq_AL.dateFormat = "yy-MM-dd";
        sq_AL.twelveHourClock = true;
        sq_AL.hourMinuteDelimiter = ".";
        sq_AL.am = "PD";
        sq_AL.pm = "MD";
        expectedLocaleData.put(new Locale("sq", "AL"), sq_AL);
        UIState.LocaleData es_AR = new UIState.LocaleData();
        es_AR.dateFormat = "dd/MM/yy";
        es_AR.twelveHourClock = false;
        es_AR.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("es", "AR"), es_AR);
        UIState.LocaleData sv_SE = new UIState.LocaleData();
        sv_SE.dateFormat = "yyyy-MM-dd";
        sv_SE.twelveHourClock = false;
        sv_SE.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("sv", "SE"), sv_SE);
        UIState.LocaleData ja_JP_x_lvariant_JP = new UIState.LocaleData();
        ja_JP_x_lvariant_JP.dateFormat = "yy/MM/dd";
        ja_JP_x_lvariant_JP.twelveHourClock = false;
        ja_JP_x_lvariant_JP.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("ja", "JP", "x-lvariant-JP"), ja_JP_x_lvariant_JP);
        UIState.LocaleData da_DK = new UIState.LocaleData();
        da_DK.dateFormat = "dd-MM-yy";
        da_DK.twelveHourClock = false;
        da_DK.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("da", "DK"), da_DK);
        UIState.LocaleData uk_UA = new UIState.LocaleData();
        uk_UA.dateFormat = "dd.MM.yy";
        uk_UA.twelveHourClock = false;
        uk_UA.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("uk", "UA"), uk_UA);
        UIState.LocaleData th_TH_u_ca_buddhist = new UIState.LocaleData();
        th_TH_u_ca_buddhist.dateFormat = "d/M/yyyy";
        th_TH_u_ca_buddhist.twelveHourClock = false;
        th_TH_u_ca_buddhist.hourMinuteDelimiter = ".";
        expectedLocaleData.put(new Locale("th", "TH", "u-ca-buddhist"), th_TH_u_ca_buddhist);
        UIState.LocaleData en_US = new UIState.LocaleData();
        en_US.dateFormat = "M/d/yy";
        en_US.twelveHourClock = true;
        en_US.hourMinuteDelimiter = ":";
        en_US.am = "AM";
        en_US.pm = "PM";
        expectedLocaleData.put(new Locale("en", "US"), en_US);
        UIState.LocaleData lv_LV = new UIState.LocaleData();
        lv_LV.dateFormat = "yy.d.M";
        lv_LV.twelveHourClock = false;
        lv_LV.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("lv", "LV"), lv_LV);
        UIState.LocaleData ja_JP_u_ca_japanese = new UIState.LocaleData();
        ja_JP_u_ca_japanese.dateFormat = "yy/MM/dd";
        ja_JP_u_ca_japanese.twelveHourClock = false;
        ja_JP_u_ca_japanese.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("ja", "JP", "u-ca-japanese"), ja_JP_u_ca_japanese);
        UIState.LocaleData en_MT = new UIState.LocaleData();
        en_MT.dateFormat = "dd/MM/yyyy";
        en_MT.twelveHourClock = false;
        en_MT.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("en", "MT"), en_MT);
        UIState.LocaleData zh_CN = new UIState.LocaleData();
        zh_CN.dateFormat = "yy-M-d";
        zh_CN.twelveHourClock = true;
        zh_CN.hourMinuteDelimiter = ":";
        zh_CN.am = "\u4e0a\u5348";
        zh_CN.pm = "\u4e0b\u5348";
        expectedLocaleData.put(new Locale("zh", "CN"), zh_CN);
        UIState.LocaleData nl_BE = new UIState.LocaleData();
        nl_BE.dateFormat = "d/MM/yy";
        nl_BE.twelveHourClock = false;
        nl_BE.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("nl", "BE"), nl_BE);
        UIState.LocaleData hi_IN = new UIState.LocaleData();
        hi_IN.dateFormat = "d/M/yy";
        hi_IN.twelveHourClock = true;
        hi_IN.hourMinuteDelimiter = ":";
        hi_IN.am = "\u092a\u0942\u0930\u094d\u0935\u093e\u0939\u094d\u0928";
        hi_IN.pm = "\u0905\u092a\u0930\u093e\u0939\u094d\u0928";
        expectedLocaleData.put(new Locale("hi", "IN"), hi_IN);
        UIState.LocaleData el_CY = new UIState.LocaleData();
        el_CY.dateFormat = "dd/MM/yyyy";
        el_CY.twelveHourClock = true;
        el_CY.hourMinuteDelimiter = ":";
        el_CY.am = "\u03a0\u039c";
        el_CY.pm = "\u039c\u039c";
        expectedLocaleData.put(new Locale("el", "CY"), el_CY);
        UIState.LocaleData de_CH = new UIState.LocaleData();
        de_CH.dateFormat = "dd.MM.yy";
        de_CH.twelveHourClock = false;
        de_CH.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("de", "CH"), de_CH);
        UIState.LocaleData ja_JP = new UIState.LocaleData();
        ja_JP.dateFormat = "yy/MM/dd";
        ja_JP.twelveHourClock = false;
        ja_JP.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("ja", "JP"), ja_JP);
        UIState.LocaleData ar_YE = new UIState.LocaleData();
        ar_YE.dateFormat = "dd/MM/yy";
        ar_YE.twelveHourClock = true;
        ar_YE.hourMinuteDelimiter = ":";
        ar_YE.am = "\u0635";
        ar_YE.pm = "\u0645";
        expectedLocaleData.put(new Locale("ar", "YE"), ar_YE);
        UIState.LocaleData ar_QA = new UIState.LocaleData();
        ar_QA.dateFormat = "dd/MM/yy";
        ar_QA.twelveHourClock = true;
        ar_QA.hourMinuteDelimiter = ":";
        ar_QA.am = "\u0635";
        ar_QA.pm = "\u0645";
        expectedLocaleData.put(new Locale("ar", "QA"), ar_QA);
        UIState.LocaleData es_GT = new UIState.LocaleData();
        es_GT.dateFormat = "d/MM/yy";
        es_GT.twelveHourClock = true;
        es_GT.hourMinuteDelimiter = ":";
        es_GT.am = "AM";
        es_GT.pm = "PM";
        expectedLocaleData.put(new Locale("es", "GT"), es_GT);
        UIState.LocaleData nn_NO = new UIState.LocaleData();
        nn_NO.dateFormat = "dd.MM.yy";
        nn_NO.twelveHourClock = false;
        nn_NO.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("nn", "NO"), nn_NO);
        UIState.LocaleData es_PE = new UIState.LocaleData();
        es_PE.dateFormat = "dd/MM/yy";
        es_PE.twelveHourClock = true;
        es_PE.hourMinuteDelimiter = ":";
        es_PE.am = "AM";
        es_PE.pm = "PM";
        expectedLocaleData.put(new Locale("es", "PE"), es_PE);
        UIState.LocaleData en_NZ = new UIState.LocaleData();
        en_NZ.dateFormat = "d/MM/yy";
        en_NZ.twelveHourClock = true;
        en_NZ.hourMinuteDelimiter = ":";
        en_NZ.am = "AM";
        en_NZ.pm = "PM";
        expectedLocaleData.put(new Locale("en", "NZ"), en_NZ);
        UIState.LocaleData be_BY = new UIState.LocaleData();
        be_BY.dateFormat = "d.M.yy";
        be_BY.twelveHourClock = false;
        be_BY.hourMinuteDelimiter = ".";
        expectedLocaleData.put(new Locale("be", "BY"), be_BY);
        UIState.LocaleData zh_SG = new UIState.LocaleData();
        zh_SG.dateFormat = "dd/MM/yy";
        zh_SG.twelveHourClock = true;
        zh_SG.hourMinuteDelimiter = ":";
        zh_SG.am = "\u4e0a\u5348";
        zh_SG.pm = "\u4e0b\u5348";
        expectedLocaleData.put(new Locale("zh", "SG"), zh_SG);
        UIState.LocaleData ro_RO = new UIState.LocaleData();
        ro_RO.dateFormat = "dd.MM.yyyy";
        ro_RO.twelveHourClock = false;
        ro_RO.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("ro", "RO"), ro_RO);
        UIState.LocaleData es_PA = new UIState.LocaleData();
        es_PA.dateFormat = "MM/dd/yy";
        es_PA.twelveHourClock = true;
        es_PA.hourMinuteDelimiter = ":";
        es_PA.am = "AM";
        es_PA.pm = "PM";
        expectedLocaleData.put(new Locale("es", "PA"), es_PA);
        UIState.LocaleData mt_MT = new UIState.LocaleData();
        mt_MT.dateFormat = "dd/MM/yyyy";
        mt_MT.twelveHourClock = false;
        mt_MT.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("mt", "MT"), mt_MT);
        UIState.LocaleData et_EE = new UIState.LocaleData();
        et_EE.dateFormat = "d.MM.yy";
        et_EE.twelveHourClock = false;
        et_EE.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("et", "EE"), et_EE);
        UIState.LocaleData it_CH = new UIState.LocaleData();
        it_CH.dateFormat = "dd.MM.yy";
        it_CH.twelveHourClock = false;
        it_CH.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("it", "CH"), it_CH);
        UIState.LocaleData th_TH_x_lvariant_TH = new UIState.LocaleData();
        th_TH_x_lvariant_TH.dateFormat = "d/M/yyyy";
        th_TH_x_lvariant_TH.twelveHourClock = false;
        th_TH_x_lvariant_TH.hourMinuteDelimiter = ".";
        expectedLocaleData.put(new Locale("th", "TH", "x-lvariant-TH"), th_TH_x_lvariant_TH);
        UIState.LocaleData tr_TR = new UIState.LocaleData();
        tr_TR.dateFormat = "dd.MM.yyyy";
        tr_TR.twelveHourClock = false;
        tr_TR.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("tr", "TR"), tr_TR);
        UIState.LocaleData fr_FR = new UIState.LocaleData();
        fr_FR.dateFormat = "dd/MM/yy";
        fr_FR.twelveHourClock = false;
        fr_FR.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("fr", "FR"), fr_FR);
        UIState.LocaleData vi_VN = new UIState.LocaleData();
        vi_VN.dateFormat = "dd/MM/yyyy";
        vi_VN.twelveHourClock = false;
        vi_VN.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("vi", "VN"), vi_VN);
        UIState.LocaleData en_GB = new UIState.LocaleData();
        en_GB.dateFormat = "dd/MM/yy";
        en_GB.twelveHourClock = false;
        en_GB.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("en", "GB"), en_GB);
        UIState.LocaleData fi_FI = new UIState.LocaleData();
        fi_FI.dateFormat = "d.M.yyyy";
        fi_FI.twelveHourClock = false;
        fi_FI.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("fi", "FI"), fi_FI);
        UIState.LocaleData en_CA = new UIState.LocaleData();
        en_CA.dateFormat = "dd/MM/yy";
        en_CA.twelveHourClock = true;
        en_CA.hourMinuteDelimiter = ":";
        en_CA.am = "AM";
        en_CA.pm = "PM";
        expectedLocaleData.put(new Locale("en", "CA"), en_CA);
        UIState.LocaleData lt_LT = new UIState.LocaleData();
        lt_LT.dateFormat = "yy.M.d";
        lt_LT.twelveHourClock = false;
        lt_LT.hourMinuteDelimiter = ".";
        expectedLocaleData.put(new Locale("lt", "LT"), lt_LT);
        UIState.LocaleData ar_AE = new UIState.LocaleData();
        ar_AE.dateFormat = "dd/MM/yy";
        ar_AE.twelveHourClock = true;
        ar_AE.hourMinuteDelimiter = ":";
        ar_AE.am = "\u0635";
        ar_AE.pm = "\u0645";
        expectedLocaleData.put(new Locale("ar", "AE"), ar_AE);
        UIState.LocaleData sl_SI = new UIState.LocaleData();
        sl_SI.dateFormat = "d.M.y";
        sl_SI.twelveHourClock = false;
        sl_SI.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("sl", "SI"), sl_SI);
        UIState.LocaleData es_DO = new UIState.LocaleData();
        es_DO.dateFormat = "dd/MM/yy";
        es_DO.twelveHourClock = true;
        es_DO.hourMinuteDelimiter = ":";
        es_DO.am = "AM";
        es_DO.pm = "PM";
        expectedLocaleData.put(new Locale("es", "DO"), es_DO);
        UIState.LocaleData ar_IQ = new UIState.LocaleData();
        ar_IQ.dateFormat = "dd/MM/yy";
        ar_IQ.twelveHourClock = true;
        ar_IQ.hourMinuteDelimiter = ":";
        ar_IQ.am = "\u0635";
        ar_IQ.pm = "\u0645";
        expectedLocaleData.put(new Locale("ar", "IQ"), ar_IQ);
        UIState.LocaleData fr_CH = new UIState.LocaleData();
        fr_CH.dateFormat = "dd.MM.yy";
        fr_CH.twelveHourClock = false;
        fr_CH.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("fr", "CH"), fr_CH);
        UIState.LocaleData es_EC = new UIState.LocaleData();
        es_EC.dateFormat = "dd/MM/yy";
        es_EC.twelveHourClock = false;
        es_EC.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("es", "EC"), es_EC);
        UIState.LocaleData es_US = new UIState.LocaleData();
        es_US.dateFormat = "M/d/yy";
        es_US.twelveHourClock = true;
        es_US.hourMinuteDelimiter = ":";
        es_US.am = "a.m.";
        es_US.pm = "p.m.";
        expectedLocaleData.put(new Locale("es", "US"), es_US);
        UIState.LocaleData iw_IL = new UIState.LocaleData();
        iw_IL.dateFormat = "dd/MM/yy";
        iw_IL.twelveHourClock = false;
        iw_IL.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("iw", "IL"), iw_IL);
        UIState.LocaleData ar_SA = new UIState.LocaleData();
        ar_SA.dateFormat = "dd/MM/yy";
        ar_SA.twelveHourClock = true;
        ar_SA.hourMinuteDelimiter = ":";
        ar_SA.am = "\u0635";
        ar_SA.pm = "\u0645";
        expectedLocaleData.put(new Locale("ar", "SA"), ar_SA);
        UIState.LocaleData ca_ES = new UIState.LocaleData();
        ca_ES.dateFormat = "dd/MM/yy";
        ca_ES.twelveHourClock = false;
        ca_ES.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("ca", "ES"), ca_ES);
        UIState.LocaleData de_DE = new UIState.LocaleData();
        de_DE.dateFormat = "dd.MM.yy";
        de_DE.twelveHourClock = false;
        de_DE.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("de", "DE"), de_DE);
        UIState.LocaleData sr_BA = new UIState.LocaleData();
        sr_BA.dateFormat = "yy-MM-dd";
        sr_BA.twelveHourClock = false;
        sr_BA.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("sr", "BA"), sr_BA);
        UIState.LocaleData zh_HK = new UIState.LocaleData();
        zh_HK.dateFormat = "yy'\u5e74'M'\u6708'd'\u65e5'";
        zh_HK.twelveHourClock = true;
        zh_HK.hourMinuteDelimiter = ":";
        zh_HK.am = "\u4e0a\u5348";
        zh_HK.pm = "\u4e0b\u5348";
        expectedLocaleData.put(new Locale("zh", "HK"), zh_HK);
        UIState.LocaleData ar_SD = new UIState.LocaleData();
        ar_SD.dateFormat = "dd/MM/yy";
        ar_SD.twelveHourClock = true;
        ar_SD.hourMinuteDelimiter = ":";
        ar_SD.am = "\u0635";
        ar_SD.pm = "\u0645";
        expectedLocaleData.put(new Locale("ar", "SD"), ar_SD);
        UIState.LocaleData pt_BR = new UIState.LocaleData();
        pt_BR.dateFormat = "dd/MM/yy";
        pt_BR.twelveHourClock = false;
        pt_BR.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("pt", "BR"), pt_BR);
        UIState.LocaleData sr_RS = new UIState.LocaleData();
        sr_RS.dateFormat = "d.M.yy.";
        sr_RS.twelveHourClock = false;
        sr_RS.hourMinuteDelimiter = ".";
        expectedLocaleData.put(new Locale("sr", "RS"), sr_RS);
        UIState.LocaleData es_UY = new UIState.LocaleData();
        es_UY.dateFormat = "dd/MM/yy";
        es_UY.twelveHourClock = true;
        es_UY.hourMinuteDelimiter = ":";
        es_UY.am = "AM";
        es_UY.pm = "PM";
        expectedLocaleData.put(new Locale("es", "UY"), es_UY);
        UIState.LocaleData ar_BH = new UIState.LocaleData();
        ar_BH.dateFormat = "dd/MM/yy";
        ar_BH.twelveHourClock = true;
        ar_BH.hourMinuteDelimiter = ":";
        ar_BH.am = "\u0635";
        ar_BH.pm = "\u0645";
        expectedLocaleData.put(new Locale("ar", "BH"), ar_BH);
        UIState.LocaleData es_ES = new UIState.LocaleData();
        es_ES.dateFormat = "d/MM/yy";
        es_ES.twelveHourClock = false;
        es_ES.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("es", "ES"), es_ES);
        UIState.LocaleData ar_JO = new UIState.LocaleData();
        ar_JO.dateFormat = "dd/MM/yy";
        ar_JO.twelveHourClock = true;
        ar_JO.hourMinuteDelimiter = ":";
        ar_JO.am = "\u0635";
        ar_JO.pm = "\u0645";
        expectedLocaleData.put(new Locale("ar", "JO"), ar_JO);
        UIState.LocaleData es_VE = new UIState.LocaleData();
        es_VE.dateFormat = "dd/MM/yy";
        es_VE.twelveHourClock = true;
        es_VE.hourMinuteDelimiter = ":";
        es_VE.am = "AM";
        es_VE.pm = "PM";
        expectedLocaleData.put(new Locale("es", "VE"), es_VE);
        UIState.LocaleData es_MX = new UIState.LocaleData();
        es_MX.dateFormat = "d/MM/yy";
        es_MX.twelveHourClock = true;
        es_MX.hourMinuteDelimiter = ":";
        es_MX.am = "AM";
        es_MX.pm = "PM";
        expectedLocaleData.put(new Locale("es", "MX"), es_MX);
        UIState.LocaleData it_IT = new UIState.LocaleData();
        it_IT.dateFormat = "dd/MM/yy";
        it_IT.twelveHourClock = false;
        it_IT.hourMinuteDelimiter = ".";
        expectedLocaleData.put(new Locale("it", "IT"), it_IT);
        UIState.LocaleData no_NO_x_lvariant_NY = new UIState.LocaleData();
        no_NO_x_lvariant_NY.dateFormat = "dd.MM.yy";
        no_NO_x_lvariant_NY.twelveHourClock = false;
        no_NO_x_lvariant_NY.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("no", "NO", "x-lvariant-NY"), no_NO_x_lvariant_NY);
        UIState.LocaleData de_LU = new UIState.LocaleData();
        de_LU.dateFormat = "dd.MM.yy";
        de_LU.twelveHourClock = false;
        de_LU.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("de", "LU"), de_LU);
        UIState.LocaleData fr_LU = new UIState.LocaleData();
        fr_LU.dateFormat = "dd/MM/yy";
        fr_LU.twelveHourClock = false;
        fr_LU.hourMinuteDelimiter = ":";
        expectedLocaleData.put(new Locale("fr", "LU"), fr_LU);
        UIState.LocaleData es_NI = new UIState.LocaleData();
        es_NI.dateFormat = "MM-dd-yy";
        es_NI.twelveHourClock = true;
        es_NI.hourMinuteDelimiter = ":";
        es_NI.am = "AM";
        es_NI.pm = "PM";
        expectedLocaleData.put(new Locale("es", "NI"), es_NI);
        UIState.LocaleData th_TH = new UIState.LocaleData();
        th_TH.dateFormat = "d/M/yyyy";
        th_TH.twelveHourClock = false;
        th_TH.hourMinuteDelimiter = ".";
        expectedLocaleData.put(new Locale("th", "TH"), th_TH);
    }
}

