/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.event.dd.DropHandler;
import com.vaadin.event.dd.DropTarget;
import com.vaadin.event.dd.TargetDetails;
import com.vaadin.server.DragAndDropService;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.AbstractComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class DragAndDropServiceTest {
    private final Logger getDragAndDropServiceLogger() {
        return Logger.getLogger(DragAndDropService.class.getName());
    }

    @Test
    @Ignore(value="This functionality is deprecated since 8.1, and the test is flaky")
    public void changeVariables_isSourceConnectorEnabledCalled() {
        final ArrayList levels = new ArrayList();
        StreamHandler handler = new StreamHandler(){

            @Override
            public synchronized void publish(LogRecord record) {
                levels.add(record.getLevel());
            }
        };
        this.getDragAndDropServiceLogger().addHandler(handler);
        HashMap<String, 2> variables = new HashMap<String, 2>();
        final boolean[] isConnectorEnabledCalled = new boolean[1];
        AbstractComponent component = new AbstractComponent(){

            public boolean isConnectorEnabled() {
                isConnectorEnabledCalled[0] = true;
                return false;
            }
        };
        variables.put("component", component);
        DragAndDropService service = new DragAndDropService((VaadinSession)EasyMock.createMock(VaadinSession.class));
        service.changeVariables(null, variables);
        this.getDragAndDropServiceLogger().removeHandler(handler);
        Assert.assertTrue((String)"isConnectorEnabled() method is not called", (boolean)isConnectorEnabledCalled[0]);
        Assert.assertTrue((String)"No warning on drop from disabled source", (boolean)levels.contains(Level.WARNING));
    }

    @Test
    @Ignore(value="This functionality is deprecated since 8.1, and the test is flaky")
    public void changeVariables_isTargetConnectorEnabledCalled() {
        final ArrayList levels = new ArrayList();
        StreamHandler handler = new StreamHandler(){

            @Override
            public void publish(LogRecord record) {
                levels.add(record.getLevel());
            }
        };
        this.getDragAndDropServiceLogger().addHandler(handler);
        HashMap<String, TestDropTarget> variables = new HashMap<String, TestDropTarget>();
        TestDropTarget target = new TestDropTarget();
        variables.put("dhowner", target);
        DragAndDropService service = new DragAndDropService((VaadinSession)EasyMock.createMock(VaadinSession.class));
        service.changeVariables(null, variables);
        this.getDragAndDropServiceLogger().removeHandler(handler);
        Assert.assertTrue((String)"isConnectorEnabled() method is not called", (boolean)target.isConnectorEnabledCalled());
        Assert.assertTrue((String)"No warning on drop to disabled target", (boolean)levels.contains(Level.WARNING));
    }

    private static class TestDropTarget
    extends AbstractComponent
    implements DropTarget {
        private boolean isConnectorEnabledCalled;

        private TestDropTarget() {
        }

        public boolean isConnectorEnabled() {
            this.isConnectorEnabledCalled = true;
            return false;
        }

        public DropHandler getDropHandler() {
            return null;
        }

        public TargetDetails translateDropTargetDetails(Map<String, Object> clientVariables) {
            return null;
        }

        boolean isConnectorEnabledCalled() {
            return this.isConnectorEnabledCalled;
        }
    }
}

