/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.navigator.Navigator;
import com.vaadin.server.AbstractClientConnector;
import com.vaadin.server.AbstractExtension;
import com.vaadin.tests.VaadinClasses;
import com.vaadin.ui.Composite;
import com.vaadin.ui.LegacyWindow;
import com.vaadin.ui.components.colorpicker.ColorPickerHistory;
import com.vaadin.ui.components.colorpicker.ColorPickerPopup;
import com.vaadin.ui.components.colorpicker.ColorPickerPreview;
import com.vaadin.ui.components.colorpicker.ColorPickerSelect;
import com.vaadin.ui.components.grid.NoSelectionModel;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class DedicatedStateTest {
    private static final Set<String> WHITE_LIST = DedicatedStateTest.createWhiteList();

    @Test
    public void checkDedicatedStates() {
        VaadinClasses.getAllServerSideClasses().stream().filter(clazz -> AbstractClientConnector.class.isAssignableFrom((Class<?>)clazz)).forEach(this::checkState);
    }

    private void checkState(Class<?> clazz) {
        if (WHITE_LIST.contains(clazz.getCanonicalName()) || Composite.class.isAssignableFrom(clazz)) {
            return;
        }
        Method getStateNoArg = this.getStateNoArg(clazz);
        Class<?> stateType = getStateNoArg.getReturnType();
        Class<?> superclass = clazz.getSuperclass();
        if (!clazz.equals(AbstractClientConnector.class) && !superclass.equals(AbstractExtension.class)) {
            Assert.assertNotEquals((String)("Class " + clazz + " has the same state type as its super class " + clazz.getSuperclass()), stateType, this.getStateNoArg(superclass).getReturnType());
        }
        try {
            Method getStateOneArg = clazz.getDeclaredMethod("getState", Boolean.TYPE);
            Assert.assertEquals(stateType, getStateOneArg.getReturnType());
        }
        catch (NoSuchMethodException e) {
            Assert.fail((String)("Class " + clazz + " doesn't have its own getState(boolean) method"));
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private Method getStateNoArg(Class<?> clazz) {
        try {
            return clazz.getDeclaredMethod("getState", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Assert.fail((String)("Class " + clazz + " doesn't have its own getState() method"));
            return null;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static Set<String> createWhiteList() {
        HashSet<String> list = new HashSet<String>();
        list.add(AbstractExtension.class.getCanonicalName());
        list.add(Navigator.EmptyView.class.getCanonicalName());
        list.add(ColorPickerHistory.class.getCanonicalName());
        list.add(ColorPickerPopup.class.getCanonicalName());
        list.add(ColorPickerPreview.class.getCanonicalName());
        list.add(ColorPickerSelect.class.getCanonicalName());
        list.add(NoSelectionModel.class.getCanonicalName());
        list.add(LegacyWindow.class.getCanonicalName());
        return list;
    }
}

