/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.server.BrowserWindowOpener;
import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.server.ResourceReference;
import com.vaadin.server.StreamResource;
import com.vaadin.shared.communication.URLReference;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class BrowserWindowOpenerTest {
    @Test
    public void setResource_urlBasedOpener_resourceIsSetAndUrlIsNull() {
        BrowserWindowOpener opener = new BrowserWindowOpener("url");
        StreamResource resource = (StreamResource)EasyMock.createMock(StreamResource.class);
        opener.setResource((Resource)resource);
        Assert.assertEquals((String)"Unexpected resource is got on getResource() method", (Object)resource, (Object)opener.getResource());
        Assert.assertNull((String)"Unexpected resource is got on getUrl() method", (Object)opener.getUrl());
        URLReference ref = (URLReference)opener.getState((boolean)false).resources.get("url");
        Assert.assertTrue((String)"Url reference in the state is not ResourceReference", (boolean)(ref instanceof ResourceReference));
        Assert.assertEquals((String)"Unexpected resource saved in state", (Object)resource, (Object)((ResourceReference)ref).getResource());
    }

    @Test
    public void setUrl_urlBasedOpener_urlIsSet() {
        BrowserWindowOpener opener = new BrowserWindowOpener("url");
        String url = "newUrl";
        opener.setUrl(url);
        Assert.assertEquals((String)"Unexpected URL is got on getURL() method", (Object)url, (Object)opener.getUrl());
        Assert.assertNotNull((String)"Unexpected resource is got on getResource() method", (Object)opener.getResource());
        URLReference ref = (URLReference)opener.getState((boolean)false).resources.get("url");
        Assert.assertTrue((String)"Url reference in the state is not ResourceReference", (boolean)(ref instanceof ResourceReference));
        Resource resource = ((ResourceReference)ref).getResource();
        Assert.assertTrue((String)"Resource reference is not ExternalResource", (boolean)(resource instanceof ExternalResource));
        Assert.assertEquals((String)"Unexpected URL in resource saved in state", (Object)url, (Object)((ExternalResource)resource).getURL());
    }
}

