/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.server;

import com.vaadin.server.BootstrapHandler;
import com.vaadin.server.DefaultDeploymentConfiguration;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinResponse;
import com.vaadin.server.VaadinServletRequest;
import com.vaadin.server.VaadinServletResponse;
import com.vaadin.server.VaadinServletService;
import com.vaadin.server.VaadinSession;
import com.vaadin.server.WebBrowser;
import com.vaadin.server.communication.ServletBootstrapHandler;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class BootstrapHandlerTest {
    private static final String VAADIN_URL = "http://host/VAADIN/";

    @Test
    public void resolveFrontendES5() {
        BootstrapHandlerTest.testResolveFrontEnd("frontend://foobar.html", "http://host/VAADIN/frontend/es5/foobar.html", new ES5Browser());
    }

    @Test
    public void resolveFrontendES6() {
        BootstrapHandlerTest.testResolveFrontEnd("frontend://foobar.html", "http://host/VAADIN/frontend/es6/foobar.html", new ES6Browser());
    }

    @Test
    public void resolveFrontendES5CustomUrl() {
        Properties properties = new Properties();
        properties.setProperty("frontend.url.es5", "https://cdn.somewhere.com/5");
        BootstrapHandlerTest.testResolveFrontEnd("frontend://foobar.html", "https://cdn.somewhere.com/5/foobar.html", new ES5Browser(), properties);
    }

    @Test
    public void resolveFrontendES6CustomUrl() {
        Properties properties = new Properties();
        properties.setProperty("frontend.url.es6", "https://cdn.somewhere.com/6");
        BootstrapHandlerTest.testResolveFrontEnd("frontend://foobar.html", "https://cdn.somewhere.com/6/foobar.html", new ES6Browser(), properties);
    }

    @Test
    public void synchronizedHandleRequest_requestTargetVAADINFolder_noUiCreated() throws IOException {
        ServletBootstrapHandler bootstrapHandler = new ServletBootstrapHandler();
        VaadinServletRequest request = (VaadinServletRequest)Mockito.mock(VaadinServletRequest.class);
        ((VaadinServletRequest)Mockito.doAnswer(invocation -> "/VAADIN").when((Object)request)).getPathInfo();
        TestVaadinServletResponse response = new TestVaadinServletResponse();
        boolean value = bootstrapHandler.synchronizedHandleRequest((VaadinSession)Mockito.mock(VaadinSession.class), (VaadinRequest)request, (VaadinResponse)response);
        Assert.assertTrue((String)"No further request handlers should be called", (boolean)value);
        Assert.assertEquals((String)"Invalid status code reported", (long)400L, (long)response.getErrorCode());
        Assert.assertEquals((String)"Invalid message reported", (Object)"Illegal context path", (Object)response.getErrorMessage());
    }

    private static void testResolveFrontEnd(String frontendUrl, String expectedUrl, WebBrowser browser) {
        BootstrapHandlerTest.testResolveFrontEnd(frontendUrl, expectedUrl, browser, new Properties());
    }

    private static void testResolveFrontEnd(String frontendUrl, String expectedUrl, WebBrowser browser, Properties customProperties) {
        BootstrapHandler.BootstrapContext context = (BootstrapHandler.BootstrapContext)Mockito.mock(BootstrapHandler.BootstrapContext.class);
        BootstrapHandler.BootstrapUriResolver resolver = new BootstrapHandler.BootstrapUriResolver(context){

            protected String getVaadinDirUrl() {
                return BootstrapHandlerTest.VAADIN_URL;
            }
        };
        VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
        Mockito.when((Object)context.getSession()).thenReturn((Object)session);
        DefaultDeploymentConfiguration configuration = new DefaultDeploymentConfiguration(BootstrapHandlerTest.class, customProperties);
        Mockito.when((Object)session.getBrowser()).thenReturn((Object)browser);
        Mockito.when((Object)session.getConfiguration()).thenReturn((Object)configuration);
        Assert.assertEquals((Object)expectedUrl, (Object)resolver.resolveVaadinUri(frontendUrl));
    }

    public static class TestVaadinServletResponse
    extends VaadinServletResponse {
        private int errorCode;
        private String errorMessage;

        private TestVaadinServletResponse() {
            super((HttpServletResponse)Mockito.mock(HttpServletResponse.class), (VaadinServletService)Mockito.mock(VaadinServletService.class));
        }

        public void sendError(int errorCode, String message) {
            this.errorCode = errorCode;
            this.errorMessage = message;
        }

        public void sendError(int sc) {
            this.errorCode = sc;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setStatus(int sc) {
            this.errorCode = sc;
        }
    }

    public static class ES6Browser
    extends WebBrowser {
        public boolean isEs6Supported() {
            return true;
        }
    }

    public static class ES5Browser
    extends WebBrowser {
        public boolean isEs6Supported() {
            return false;
        }
    }
}

