/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data.validator;

import com.vaadin.data.ValidationResult;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueContext;
import com.vaadin.data.validator.AbstractValidator;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Before;

public class ValidatorTestBase {
    private Label localeContext;

    @Before
    public void setUp() {
        this.localeContext = new Label();
        this.setLocale(Locale.US);
    }

    protected <T> void assertPasses(T value, Validator<? super T> validator) {
        ValidationResult result = validator.apply(value, new ValueContext());
        if (result.isError()) {
            Assert.fail((String)(value + " should pass " + validator + " but got " + result.getErrorMessage()));
        }
    }

    protected <T> void assertFails(T value, String errorMessage, Validator<? super T> validator) {
        ValidationResult result = validator.apply(value, new ValueContext((Component)this.localeContext));
        Assert.assertTrue((boolean)result.isError());
        Assert.assertEquals((Object)errorMessage, (Object)result.getErrorMessage());
    }

    protected <T> void assertFails(T value, AbstractValidator<? super T> v) {
        this.assertFails(value, v.getMessage(value), (Validator<? super T>)v);
    }

    protected void setLocale(Locale locale) {
        this.localeContext.setLocale(locale);
    }
}

