/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data.validator;

import com.vaadin.data.validator.StringLengthValidator;
import com.vaadin.data.validator.ValidatorTestBase;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Test;

public class StringLengthValidatorTest
extends ValidatorTestBase {
    private static final String LONG_STRING = Stream.generate(() -> "x").limit(1000L).collect(Collectors.joining());

    @Test
    public void testNullStringFails() {
        this.assertPasses(null, new StringLengthValidator("", Integer.valueOf(0), Integer.valueOf(10)));
    }

    @Test
    public void testMaxLengthTooLongStringFails() {
        this.assertFails(LONG_STRING, new StringLengthValidator("Should be at most 10", null, Integer.valueOf(10)));
    }

    @Test
    public void testMaxLengthStringPasses() {
        this.assertPasses(LONG_STRING, new StringLengthValidator("Should be at most 1000", null, Integer.valueOf(1000)));
    }

    @Test
    public void testMinLengthEmptyStringFails() {
        this.assertFails("", new StringLengthValidator("Should be at least 1", Integer.valueOf(1), null));
    }

    @Test
    public void testMinLengthStringPasses() {
        this.assertPasses("\u00e5", new StringLengthValidator("Should be at least 1", Integer.valueOf(1), null));
    }
}

