/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data.validator;

import com.vaadin.data.validator.BeanValidator;
import com.vaadin.data.validator.ValidatorTestBase;
import com.vaadin.tests.data.bean.Address;
import com.vaadin.tests.data.bean.BeanToValidate;
import com.vaadin.ui.UI;
import java.util.Calendar;
import java.util.Locale;
import org.junit.After;
import org.junit.Test;

public class BeanValidatorTest
extends ValidatorTestBase {
    @Test
    public void testFirstNameNullFails() {
        this.assertFails(null, "may not be null", this.validator("firstname"));
    }

    @Test
    public void testFirstNameTooShortFails() {
        this.assertFails("x", "size must be between 3 and 16", this.validator("firstname"));
    }

    @Test
    public void testFirstNameLongEnoughPasses() {
        this.assertPasses("Magi", this.validator("firstname"));
    }

    @Test
    public void testAgeTooYoungFails() {
        this.assertFails(14, "Must be 18 or above", this.validator("age"));
    }

    @Test
    public void testDateOfBirthNullPasses() {
        this.assertPasses(null, this.validator("dateOfBirth"));
    }

    @Test
    public void testDateOfBirthInTheFutureFails() {
        Calendar year3k = Calendar.getInstance();
        year3k.set(3000, 0, 1);
        this.assertFails(year3k, "must be in the past", this.validator("dateOfBirth"));
    }

    @Test
    public void testAddressesEmptyArrayPasses() {
        Address[] noAddresses = new Address[]{};
        this.assertPasses(noAddresses, this.validator("addresses"));
    }

    @Test
    public void testAddressesNullFails() {
        this.assertFails(null, "may not be null", this.validator("addresses"));
    }

    @Test
    public void testInvalidDecimalsFailsInFrench() {
        this.setLocale(Locale.FRENCH);
        BeanValidator v = this.validator("decimals");
        this.assertFails("1234.567", "valeur num\u00e9rique hors limite (<3 chiffres>.<2 chiffres> attendu)", v);
    }

    @Test
    public void testAddressNestedPropertyInvalidPostalCodeFails() {
        this.assertFails(100000, "must be less than or equal to 99999", this.validator("address.postalCode"));
    }

    @Test
    public void testNullValuePasses() {
        this.assertPasses(null, this.validator("nickname"));
    }

    @After
    public void tearDown() {
        UI.setCurrent(null);
    }

    private BeanValidator validator(String propertyName) {
        return new BeanValidator(BeanToValidate.class, propertyName);
    }
}

