/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data.provider.bov;

import com.vaadin.data.provider.CallbackDataProvider;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.QuerySortOrder;
import com.vaadin.data.provider.bov.Person;
import com.vaadin.data.provider.bov.PersonService;
import com.vaadin.shared.data.sort.SortDirection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Before;
import org.junit.Test;

public class DataProviderBoVTest {
    private PersonServiceImpl personService;

    @Test
    public void testPersons() {
        DataProvider<Person, ?> dataProvider = this.createUnsortedDataProvider();
    }

    private DataProvider<Person, ?> createUnsortedDataProvider() {
        CallbackDataProvider dataProvider = DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            int offset = query.getOffset();
            int limit = query.getLimit();
            List<Person> persons = this.getPersonService().fetchPersons(offset, limit);
            return persons.stream();
        }, (CallbackDataProvider.CountCallback & Serializable)query -> this.getPersonService().getPersonCount());
        return dataProvider;
    }

    @Test
    public void testSortedPersons() {
        DataProvider<Person, ?> dataProvider = this.createSortedDataProvider();
    }

    private DataProvider<Person, ?> createSortedDataProvider() {
        CallbackDataProvider dataProvider = DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> {
            ArrayList<PersonService.PersonSort> sortOrders = new ArrayList<PersonService.PersonSort>();
            for (QuerySortOrder queryOrder : query.getSortOrders()) {
                PersonService.PersonSort sort = this.personService.createSort(queryOrder.getSorted(), queryOrder.getDirection() == SortDirection.DESCENDING);
                sortOrders.add(sort);
            }
            return this.getPersonService().fetchPersons(query.getOffset(), query.getLimit(), sortOrders).stream();
        }, (CallbackDataProvider.CountCallback & Serializable)query -> this.getPersonService().getPersonCount());
        return dataProvider;
    }

    public PersonServiceImpl getPersonService() {
        return this.personService;
    }

    @Before
    public void buildService() {
        this.personService = new PersonServiceImpl(new Person("George Washington", 1732), new Person("John Adams", 1735), new Person("Thomas Jefferson", 1743), new Person("James Madison", 1751));
    }

    public static class PersonServiceImpl
    implements PersonService {
        final Person[] persons;

        public PersonServiceImpl(Person ... persons) {
            this.persons = persons;
        }

        @Override
        public List<Person> fetchPersons(int offset, int limit) {
            return Arrays.stream(this.persons).skip(offset).limit(limit).collect(Collectors.toList());
        }

        @Override
        public List<Person> fetchPersons(int offset, int limit, Collection<PersonService.PersonSort> personSorts) {
            Stream<Person> personStream = Arrays.stream(this.persons).skip(offset).limit(limit);
            if (personSorts != null) {
                for (PersonService.PersonSort personSort : personSorts) {
                    personStream = personStream.sorted(personSort);
                }
            }
            return personStream.collect(Collectors.toList());
        }

        @Override
        public int getPersonCount() {
            return this.persons.length;
        }

        @Override
        public PersonService.PersonSort createSort(String propertyName, boolean descending) {
            PersonService.PersonSort result;
            switch (propertyName) {
                case "name": {
                    result = (person1, person2) -> String.CASE_INSENSITIVE_ORDER.compare(person1.getName(), person2.getName());
                    break;
                }
                case "born": {
                    result = (person1, person2) -> person2.getBorn() - person1.getBorn();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("wrong field name " + propertyName);
                }
            }
            if (descending) {
                return (person1, person2) -> result.compare(person2, person1);
            }
            return result;
        }
    }
}

