/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data.provider;

import com.vaadin.data.provider.DataCommunicator;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ListDataProvider;
import java.util.List;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;

public class ReplaceDataProviderTest {
    @Test
    public void testBeanEquals() {
        this.doTest(BeanWithEquals::new);
    }

    @Test
    public void testBeanSame() {
        this.doTest(Bean::new);
    }

    private <SOME_BEAN> void doTest(IntFunction<SOME_BEAN> beanConstructor) {
        DataCommunicator dataCommunicator = new DataCommunicator();
        List<SOME_BEAN> beans1 = this.createCollection(beanConstructor);
        ListDataProvider dataProvider = new ListDataProvider(beans1);
        dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        dataCommunicator.pushData(1, beans1);
        SOME_BEAN bean1_17 = beans1.get(17);
        String key1_17 = dataCommunicator.getKeyMapper().key(bean1_17);
        Assert.assertSame(bean1_17, (Object)dataCommunicator.getKeyMapper().get(key1_17));
        List<SOME_BEAN> beans2 = this.createCollection(beanConstructor);
        dataProvider = new ListDataProvider(beans2);
        dataCommunicator.setDataProvider((DataProvider)dataProvider, null);
        dataCommunicator.pushData(1, beans2);
        SOME_BEAN bean2_17 = beans2.get(17);
        String key2_17 = dataCommunicator.getKeyMapper().key(bean2_17);
        Assert.assertSame(bean2_17, (Object)dataCommunicator.getKeyMapper().get(key2_17));
        Assert.assertNotEquals((Object)key2_17, (Object)key1_17);
        Assert.assertNull((Object)dataCommunicator.getKeyMapper().get(key1_17));
    }

    private <SOME_BEAN> List<SOME_BEAN> createCollection(IntFunction<SOME_BEAN> beanConstructor) {
        return IntStream.range(1, 100).mapToObj(beanConstructor).collect(Collectors.toList());
    }

    public static class Bean {
        protected final int id;
        private final String fluff;

        Bean(int id) {
            this.id = id;
            this.fluff = "Fluff #" + id;
        }

        public int getId() {
            return this.id;
        }

        public String getFluff() {
            return this.fluff;
        }
    }

    public static class BeanWithEquals
    extends Bean {
        BeanWithEquals(int id) {
            super(id);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BeanWithEquals that = (BeanWithEquals)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

