/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data.provider;

import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.DataProviderTestBase;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.data.provider.Query;
import com.vaadin.data.provider.QuerySortOrder;
import com.vaadin.data.provider.StrBean;
import com.vaadin.server.SerializableBiPredicate;
import com.vaadin.server.SerializableComparator;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.shared.data.sort.SortDirection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class ListDataProviderTest
extends DataProviderTestBase<ListDataProvider<StrBean>> {
    @Override
    protected ListDataProvider<StrBean> createDataProvider() {
        return DataProvider.ofCollection((Collection)this.data);
    }

    @Test
    public void dataProvider_ofItems_shouldCreateAnEditableDataProvider() {
        ListDataProvider dataProvider = DataProvider.ofItems((Object[])new String[]{"0", "1"});
        Assert.assertTrue((String)"DataProvider.ofItems should create a list data provider backed an ArrayList allowing edits", (boolean)(dataProvider.getItems() instanceof ArrayList));
        List list = (List)dataProvider.getItems();
        list.add(0, "2");
    }

    @Test
    public void setSortByProperty_ascending() {
        ListDataProvider dataProvider = (ListDataProvider)this.getDataProvider();
        dataProvider.setSortOrder(StrBean::getId, SortDirection.ASCENDING);
        int[] threeFirstIds = dataProvider.fetch(new Query()).mapToInt(StrBean::getId).limit(3L).toArray();
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2}, (int[])threeFirstIds);
    }

    @Test
    public void setSortByProperty_descending() {
        ListDataProvider dataProvider = (ListDataProvider)this.getDataProvider();
        dataProvider.setSortOrder(StrBean::getId, SortDirection.DESCENDING);
        int[] threeFirstIds = dataProvider.fetch(new Query()).mapToInt(StrBean::getId).limit(3L).toArray();
        Assert.assertArrayEquals((int[])new int[]{98, 97, 96}, (int[])threeFirstIds);
    }

    @Test
    public void testMultipleSortOrder_firstAddedWins() {
        ListDataProvider dataProvider = (ListDataProvider)this.getDataProvider();
        dataProvider.addSortOrder(StrBean::getValue, SortDirection.DESCENDING);
        dataProvider.addSortOrder(StrBean::getId, SortDirection.DESCENDING);
        List threeFirstItems = dataProvider.fetch(new Query()).limit(3L).collect(Collectors.toList());
        Assert.assertEquals((Object)new StrBean("Xyz", 10, 100), threeFirstItems.get(0));
        Assert.assertEquals((Object)new StrBean("Foo", 93, 2), threeFirstItems.get(1));
        Assert.assertEquals((Object)new StrBean("Foo", 91, 2), threeFirstItems.get(2));
    }

    @Test
    public void setFilter() {
        ((ListDataProvider)this.dataProvider).setFilter((SerializablePredicate & Serializable)item -> item.getValue().equals("Foo"));
        Assert.assertEquals((long)36L, (long)this.sizeWithUnfilteredQuery());
        ((ListDataProvider)this.dataProvider).setFilter((SerializablePredicate & Serializable)item -> !item.getValue().equals("Foo"));
        Assert.assertEquals((String)"Previous filter should be reset when setting a new one", (long)64L, (long)this.sizeWithUnfilteredQuery());
        ((ListDataProvider)this.dataProvider).setFilter(null);
        Assert.assertEquals((String)"Setting filter to null should remove all filters", (long)100L, (long)this.sizeWithUnfilteredQuery());
    }

    @Test
    public void setFilter_valueProvider() {
        ((ListDataProvider)this.dataProvider).setFilter(StrBean::getValue, "Foo"::equals);
        Assert.assertEquals((long)36L, (long)this.sizeWithUnfilteredQuery());
        ((ListDataProvider)this.dataProvider).setFilter(StrBean::getValue, (SerializablePredicate & Serializable)value -> !value.equals("Foo"));
        Assert.assertEquals((String)"Previous filter should be reset when setting a new one", (long)64L, (long)this.sizeWithUnfilteredQuery());
    }

    @Test
    public void setFilterEquals() {
        ((ListDataProvider)this.dataProvider).setFilterByValue(StrBean::getValue, (Object)"Foo");
        Assert.assertEquals((long)36L, (long)this.sizeWithUnfilteredQuery());
        ((ListDataProvider)this.dataProvider).setFilterByValue(StrBean::getValue, (Object)"Bar");
        Assert.assertEquals((long)23L, (long)this.sizeWithUnfilteredQuery());
    }

    @Test
    public void addFilter_withPreviousFilter() {
        ((ListDataProvider)this.dataProvider).setFilterByValue(StrBean::getValue, (Object)"Foo");
        ((ListDataProvider)this.dataProvider).addFilter((SerializablePredicate & Serializable)item -> item.getId() > 50);
        Assert.assertEquals((String)"Both filters should be used", (long)17L, (long)this.sizeWithUnfilteredQuery());
    }

    @Test
    public void addFilter_noPreviousFilter() {
        ((ListDataProvider)this.dataProvider).addFilter((SerializablePredicate & Serializable)item -> item.getId() > 50);
        Assert.assertEquals((long)48L, (long)this.sizeWithUnfilteredQuery());
    }

    @Test
    public void addFilter_valueProvider() {
        ((ListDataProvider)this.dataProvider).setFilter((SerializablePredicate & Serializable)item -> item.getId() > 50);
        ((ListDataProvider)this.dataProvider).addFilter(StrBean::getValue, "Foo"::equals);
        Assert.assertEquals((String)"Both filters should be used", (long)17L, (long)this.sizeWithUnfilteredQuery());
    }

    @Test
    public void addFilterEquals() {
        ((ListDataProvider)this.dataProvider).setFilter((SerializablePredicate & Serializable)item -> item.getId() > 50);
        ((ListDataProvider)this.dataProvider).addFilterByValue(StrBean::getValue, (Object)"Foo");
        Assert.assertEquals((String)"Both filters should be used", (long)17L, (long)this.sizeWithUnfilteredQuery());
    }

    @Test
    public void addFilter_firstAddedUsedFirst() {
        ((ListDataProvider)this.dataProvider).addFilter((SerializablePredicate & Serializable)item -> false);
        ((ListDataProvider)this.dataProvider).addFilter((SerializablePredicate & Serializable)item -> {
            Assert.fail((String)"This filter should never be invoked");
            return true;
        });
        Assert.assertEquals((long)0L, (long)this.sizeWithUnfilteredQuery());
    }

    @Test
    public void combineProviderAndQueryFilters() {
        ((ListDataProvider)this.dataProvider).addFilterByValue(StrBean::getValue, (Object)"Foo");
        int size = ((ListDataProvider)this.dataProvider).size(new Query((SerializablePredicate & Serializable)item -> item.getId() > 50));
        Assert.assertEquals((String)"Both filters should be used", (long)17L, (long)size);
    }

    @Test
    public void providerFilterBeforeQueryFilter() {
        ((ListDataProvider)this.dataProvider).setFilter((SerializablePredicate & Serializable)item -> false);
        int size = ((ListDataProvider)this.dataProvider).size(new Query((SerializablePredicate & Serializable)item -> {
            Assert.fail((String)"This filter should never be invoked");
            return true;
        }));
        Assert.assertEquals((long)0L, (long)size);
    }

    @Test
    public void filteringBy_itemPredicate() {
        DataProvider filteringBy = ((ListDataProvider)this.dataProvider).filteringBy((SerializableBiPredicate & Serializable)(item, filterValue) -> item.getValue().equals(filterValue));
        ListDataProviderTest.assertSizeWithFilter(36, filteringBy, "Foo");
    }

    @Test
    public void filteringBy_equals() {
        DataProvider filteringBy = ((ListDataProvider)this.dataProvider).filteringByEquals(StrBean::getValue);
        ListDataProviderTest.assertSizeWithFilter(36, filteringBy, "Foo");
    }

    @Test
    public void filteringBy_propertyValuePredicate() {
        DataProvider filteringBy = ((ListDataProvider)this.dataProvider).filteringBy(StrBean::getId, (SerializableBiPredicate & Serializable)(propertyValue, filterValue) -> propertyValue >= filterValue);
        ListDataProviderTest.assertSizeWithFilter(90, filteringBy, 10);
    }

    @Test
    public void filteringBy_caseInsensitiveSubstring() {
        DataProvider filteringBy = ((ListDataProvider)this.dataProvider).filteringBySubstring(StrBean::getValue, Locale.ENGLISH);
        ListDataProviderTest.assertSizeWithFilter(36, filteringBy, "oo");
        ListDataProviderTest.assertSizeWithFilter(36, filteringBy, "Oo");
    }

    @Test
    public void filterBy_caseInsensitivePrefix() {
        DataProvider filteringBy = ((ListDataProvider)this.dataProvider).filteringByPrefix(StrBean::getValue, Locale.ENGLISH);
        ListDataProviderTest.assertSizeWithFilter(36, filteringBy, "Fo");
        ListDataProviderTest.assertSizeWithFilter(36, filteringBy, "fo");
        ListDataProviderTest.assertSizeWithFilter(0, filteringBy, "oo");
    }

    @Override
    protected void setSortOrder(List<QuerySortOrder> sortOrder, Comparator<StrBean> comp) {
        SerializableComparator & Serializable serializableComp = comp::compare;
        ((ListDataProvider)this.getDataProvider()).setSortComparator((SerializableComparator)serializableComp);
    }
}

