/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data.provider;

import com.vaadin.data.provider.BackEndDataProvider;
import com.vaadin.data.provider.CallbackDataProvider;
import com.vaadin.data.provider.DataProviderTestBase;
import com.vaadin.data.provider.QuerySortOrder;
import com.vaadin.data.provider.SortOrder;
import com.vaadin.data.provider.StrBean;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.shared.data.sort.SortDirection;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class BackendDataProviderTest
extends DataProviderTestBase<BackEndDataProvider<StrBean, SerializablePredicate<StrBean>>> {
    private static Map<String, Comparator<StrBean>> propertyToComparatorMap = new HashMap<String, Comparator<StrBean>>();

    private static Comparator<StrBean> getComparator(SortOrder<String> so) {
        Comparator<StrBean> comparator = propertyToComparatorMap.get(so.getSorted());
        if (so.getDirection() == SortDirection.DESCENDING) {
            comparator = comparator.reversed();
        }
        return comparator;
    }

    @Override
    protected BackEndDataProvider<StrBean, SerializablePredicate<StrBean>> createDataProvider() {
        this.dataProvider = new StrBeanBackEndDataProvider(this.data);
        return (BackEndDataProvider)this.dataProvider;
    }

    @Override
    protected void setSortOrder(List<QuerySortOrder> sortOrder, Comparator<StrBean> comp) {
        ((BackEndDataProvider)this.getDataProvider()).setSortOrders(sortOrder);
    }

    static {
        propertyToComparatorMap.put("value", Comparator.comparing(StrBean::getValue));
        propertyToComparatorMap.put("id", Comparator.comparing(StrBean::getId));
        propertyToComparatorMap.put("randomNumber", Comparator.comparing(StrBean::getRandomNumber));
    }

    public static class StrBeanBackEndDataProvider
    extends CallbackDataProvider<StrBean, SerializablePredicate<StrBean>> {
        public StrBeanBackEndDataProvider(List<StrBean> data) {
            super((CallbackDataProvider.FetchCallback & Serializable)query -> {
                Stream<StrBean> stream = data.stream().filter(t -> ((SerializablePredicate)query.getFilter().orElse((SerializablePredicate & Serializable)s -> true)).test(t));
                if (!query.getSortOrders().isEmpty()) {
                    Comparator sorting;
                    try (Stream<Comparator> comparingStream = query.getSortOrders().stream().map(x$0 -> BackendDataProviderTest.getComparator((SortOrder<String>)x$0));){
                        sorting = comparingStream.reduce((c1, c2) -> c1.thenComparing(c2)).get();
                    }
                    stream = stream.sorted(sorting);
                }
                return stream.skip(query.getOffset()).limit(query.getLimit());
            }, (CallbackDataProvider.CountCallback & Serializable)query -> {
                try (Stream<StrBean> stream = data.stream().filter(t -> ((SerializablePredicate)query.getFilter().orElse((SerializablePredicate & Serializable)s -> true)).test(t));){
                    int n = (int)stream.count();
                    return n;
                }
            });
        }
    }
}

