/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data.provider;

import com.vaadin.data.provider.AbstractDataProvider;
import com.vaadin.data.provider.DataChangeEvent;
import com.vaadin.data.provider.DataProviderListener;
import com.vaadin.data.provider.Query;
import com.vaadin.shared.Registration;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class AbstractDataProviderTest {
    @Test
    public void refreshAll_notifyListeners() {
        TestDataProvider dataProvider = new TestDataProvider();
        AtomicReference event = new AtomicReference();
        dataProvider.addDataProviderListener((DataProviderListener & Serializable)ev -> {
            Assert.assertNull(event.get());
            event.set(ev);
        });
        dataProvider.refreshAll();
        Assert.assertNotNull(event.get());
        Assert.assertEquals((Object)((Object)dataProvider), (Object)((DataChangeEvent)event.get()).getSource());
    }

    @Test
    public void removeListener_listenerIsNotNotified() {
        TestDataProvider dataProvider = new TestDataProvider();
        AtomicReference event = new AtomicReference();
        Registration registration = dataProvider.addDataProviderListener((DataProviderListener & Serializable)ev -> event.set(ev));
        registration.remove();
        dataProvider.refreshAll();
        Assert.assertNull(event.get());
    }

    private static class TestDataProvider
    extends AbstractDataProvider<Object, Object> {
        private TestDataProvider() {
        }

        public Stream<Object> fetch(Query<Object, Object> t) {
            return null;
        }

        public int size(Query<Object, Object> t) {
            return 0;
        }

        public boolean isInMemory() {
            return false;
        }
    }
}

