/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data;

import com.vaadin.data.Binder;
import com.vaadin.data.Converter;
import com.vaadin.data.Validator;
import com.vaadin.server.SerializableFunction;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.ui.TextField;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import org.junit.After;
import org.junit.Before;

public abstract class BinderTestBase<BINDER extends Binder<ITEM>, ITEM>
implements Serializable {
    protected static final String NEGATIVE_ERROR_MESSAGE = "Value must be non-negative";
    protected static final String NOT_NUMBER_ERROR_MESSAGE = "Value must be a number";
    protected static final String EMPTY_ERROR_MESSAGE = "Value cannot be empty";
    protected BINDER binder;
    protected ITEM item;
    protected TextField nameField;
    protected TextField ageField;
    protected Validator<String> notEmpty = Validator.from((SerializablePredicate & Serializable)val -> !val.isEmpty(), (String)"Value cannot be empty");
    protected Converter<String, Integer> stringToInteger = Converter.from(Integer::valueOf, String::valueOf, (SerializableFunction & Serializable)e -> "Value must be a number");
    protected Validator<Integer> notNegative = Validator.from((SerializablePredicate & Serializable)x -> x >= 0, (String)"Value must be non-negative");

    public static void testSerialization(Object toSerialize) {
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new ByteArrayOutputStream());){
            objectOutputStream.writeObject(toSerialize);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Before
    public void setUpBase() {
        this.nameField = new TextField();
        this.nameField.setLocale(Locale.US);
        this.ageField = new TextField();
        this.ageField.setLocale(Locale.US);
    }

    @After
    public void testBinderSerialization() {
        BinderTestBase.testSerialization(this.binder);
    }
}

