/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data;

import com.vaadin.data.Binder;
import com.vaadin.data.BinderTestBase;
import com.vaadin.tests.data.bean.Person;
import com.vaadin.tests.data.bean.Sex;
import com.vaadin.ui.NativeSelect;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BinderSingleSelectTest
extends BinderTestBase<Binder<Person>, Person> {
    private NativeSelect<Sex> select;

    @Before
    public void setUp() {
        this.binder = new Binder();
        this.item = new Person();
        this.select = new NativeSelect();
        this.select.setItems((Object[])Sex.values());
    }

    @Test
    public void personBound_bindSelectByShortcut_selectionUpdated() {
        ((Person)this.item).setSex(Sex.FEMALE);
        this.binder.setBean((Object)((Person)this.item));
        this.binder.bind(this.select, Person::getSex, Person::setSex);
        Assert.assertSame((Object)((Object)Sex.FEMALE), this.select.getSelectedItem().orElse(null));
    }

    @Test
    public void personBound_bindSelect_selectionUpdated() {
        ((Person)this.item).setSex(Sex.MALE);
        this.binder.setBean((Object)((Person)this.item));
        this.binder.forField(this.select).bind(Person::getSex, Person::setSex);
        Assert.assertSame((Object)((Object)Sex.MALE), this.select.getSelectedItem().orElse(null));
    }

    @Test
    public void selectBound_bindPersonWithNullSex_selectedItemNotPresent() {
        this.bindSex();
        Assert.assertFalse((boolean)this.select.getSelectedItem().isPresent());
    }

    @Test
    public void selectBound_bindPerson_selectionUpdated() {
        ((Person)this.item).setSex(Sex.FEMALE);
        this.bindSex();
        Assert.assertSame((Object)((Object)Sex.FEMALE), this.select.getSelectedItem().orElse(null));
    }

    @Test
    public void bound_setSelection_beanValueUpdated() {
        this.bindSex();
        this.select.setValue((Object)Sex.MALE);
        Assert.assertSame((Object)((Object)Sex.MALE), (Object)((Object)((Person)this.item).getSex()));
    }

    @Test
    public void bound_deselect_beanValueUpdatedToNull() {
        ((Person)this.item).setSex(Sex.MALE);
        this.bindSex();
        this.select.setValue(null);
        Assert.assertNull((Object)((Object)((Person)this.item).getSex()));
    }

    @Test
    public void unbound_changeSelection_beanValueNotUpdated() {
        ((Person)this.item).setSex(Sex.UNKNOWN);
        this.bindSex();
        this.binder.removeBean();
        this.select.setValue((Object)Sex.FEMALE);
        Assert.assertSame((Object)((Object)Sex.UNKNOWN), (Object)((Object)((Person)this.item).getSex()));
    }

    protected void bindSex() {
        this.binder.forField(this.select).bind(Person::getSex, Person::setSex);
        this.binder.setBean((Object)((Person)this.item));
    }
}

