/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data;

import com.vaadin.annotations.PropertyId;
import com.vaadin.data.BeanPropertySet;
import com.vaadin.data.Binder;
import com.vaadin.data.Converter;
import com.vaadin.data.ConvertibleValues;
import com.vaadin.data.HasValue;
import com.vaadin.data.PropertyFilterDefinition;
import com.vaadin.data.Validator;
import com.vaadin.data.converter.StringToIntegerConverter;
import com.vaadin.data.validator.StringLengthValidator;
import com.vaadin.server.SerializableFunction;
import com.vaadin.tests.data.bean.Address;
import com.vaadin.tests.data.bean.Person;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.AbstractTextField;
import com.vaadin.ui.DateField;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.TextField;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;

public class BinderInstanceFieldTest {
    @Test
    public void bindInstanceFields_bindAllFields() {
        BindAllFields form = new BindAllFields();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        person.setFirstName("foo");
        person.setBirthDate(LocalDate.now());
        binder.setBean((Object)person);
        Assert.assertEquals((Object)person.getFirstName(), (Object)form.firstName.getValue());
        Assert.assertEquals((Object)person.getBirthDate(), (Object)form.birthDate.getValue());
        form.firstName.setValue("bar");
        form.birthDate.setValue((Temporal)person.getBirthDate().plusDays(345L));
        Assert.assertEquals((Object)form.firstName.getValue(), (Object)person.getFirstName());
        Assert.assertEquals((Object)form.birthDate.getValue(), (Object)person.getBirthDate());
    }

    @Test(expected=IllegalStateException.class)
    public void bind_instanceFields_noArgsConstructor() {
        BindAllFields form = new BindAllFields();
        Binder binder = new Binder();
        binder.bindInstanceFields((Object)form);
    }

    @Test
    public void bindInstanceFields_bindOnlyOneFields() {
        BindOnlyOneField form = new BindOnlyOneField();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        person.setFirstName("foo");
        binder.setBean((Object)person);
        Assert.assertEquals((Object)person.getFirstName(), (Object)form.firstName.getValue());
        Assert.assertNull((Object)form.noFieldInPerson);
        form.firstName.setValue("bar");
        Assert.assertEquals((Object)form.firstName.getValue(), (Object)person.getFirstName());
    }

    @Test
    public void bindInstanceFields_bindNotHasValueField_fieldIsNull() {
        BindFieldHasWrongType form = new BindFieldHasWrongType();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        person.setFirstName("foo");
        binder.setBean((Object)person);
        Assert.assertNull((Object)form.firstName);
    }

    @Test
    public void bindInstanceFields_genericField() {
        BindGenericField form = new BindGenericField();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        person.setFirstName("foo");
        binder.setBean((Object)person);
        Assert.assertEquals((Object)person.getFirstName(), form.firstName.getValue());
        form.firstName.setValue("bar");
        Assert.assertEquals(form.firstName.getValue(), (Object)person.getFirstName());
    }

    @Test(expected=IllegalStateException.class)
    public void bindInstanceFields_genericFieldWithWrongTypeParameter() {
        BindGenericWrongTypeParameterField form = new BindGenericWrongTypeParameterField();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
    }

    @Test(expected=IllegalStateException.class)
    public void bindInstanceFields_generic() {
        BindGeneric form = new BindGeneric();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields(form);
    }

    @Test(expected=IllegalStateException.class)
    public void bindInstanceFields_rawFieldType() {
        BindRaw form = new BindRaw();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
    }

    @Test(expected=IllegalStateException.class)
    public void bindInstanceFields_abstractFieldType() {
        BindAbstract form = new BindAbstract();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
    }

    @Test(expected=IllegalStateException.class)
    public void bindInstanceFields_noInstantiatableFieldType() {
        BindNonInstantiatableType form = new BindNonInstantiatableType();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
    }

    @Test(expected=IllegalStateException.class)
    public void bindInstanceFields_wrongFieldType() {
        BindWrongTypeParameterField form = new BindWrongTypeParameterField();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
    }

    @Test
    public void bindInstanceFields_complexGenericHierarchy() {
        BindComplextHierarchyGenericType form = new BindComplextHierarchyGenericType();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        person.setFirstName("foo");
        binder.setBean((Object)person);
        Assert.assertEquals((Object)person.getFirstName(), form.firstName.getValue());
        form.firstName.setValue("bar");
        Assert.assertEquals(form.firstName.getValue(), (Object)person.getFirstName());
    }

    @Test
    public void bindInstanceFields_bindNotHasValueField_fieldIsNotReplaced() {
        BindFieldHasWrongType form = new BindFieldHasWrongType();
        Binder binder = new Binder(Person.class);
        String name = "foo";
        form.firstName = name;
        Person person = new Person();
        person.setFirstName("foo");
        binder.setBean((Object)person);
        Assert.assertEquals((Object)name, (Object)form.firstName);
    }

    @Test
    public void bindInstanceFields_bindAllFieldsUsingAnnotations() {
        BindFieldsUsingAnnotation form = new BindFieldsUsingAnnotation();
        Binder binder = new Binder(Person.class);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        person.setFirstName("foo");
        person.setBirthDate(LocalDate.now());
        binder.setBean((Object)person);
        Assert.assertEquals((Object)person.getFirstName(), (Object)form.nameField.getValue());
        Assert.assertEquals((Object)person.getBirthDate(), (Object)form.birthDateField.getValue());
        form.nameField.setValue("bar");
        form.birthDateField.setValue((Temporal)person.getBirthDate().plusDays(345L));
        Assert.assertEquals((Object)form.nameField.getValue(), (Object)person.getFirstName());
        Assert.assertEquals((Object)form.birthDateField.getValue(), (Object)person.getBirthDate());
    }

    @Test
    public void bindInstanceFields_bindNestedFieldUsingAnnotation() {
        BindNestedFieldsUsingAnnotation form = new BindNestedFieldsUsingAnnotation();
        Binder binder = new Binder(Person.class, true);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        Address address = new Address();
        address.setStreetAddress("Foo st.");
        person.setAddress(address);
        binder.setBean((Object)person);
        Assert.assertEquals((String)"Reading nested properties bound using annotation", (Object)person.getAddress().getStreetAddress(), (Object)form.streetAddressField.getValue());
        form.streetAddressField.setValue("Bar ave.");
        Assert.assertEquals((String)"Changing nested properties bound using annotation", (Object)form.streetAddressField.getValue(), (Object)person.getAddress().getStreetAddress());
    }

    @Test
    public void bindInstanceFields_bindDeepNestedFieldsUsingAnnotation() {
        BindDeepNestedFieldsUsingAnnotation form = new BindDeepNestedFieldsUsingAnnotation();
        Binder binder = new Binder(Couple.class, true);
        binder.bindInstanceFields((Object)form);
        Person first = new Person();
        Person second = new Person();
        Address firstAddress = new Address();
        firstAddress.setStreetAddress("Foo st.");
        first.setAddress(firstAddress);
        Address secondAddress = new Address();
        second.setAddress(secondAddress);
        secondAddress.setStreetAddress("Bar ave.");
        Couple couple = new Couple();
        couple.setFirst(first);
        couple.setSecond(second);
        binder.setBean((Object)couple);
        Assert.assertEquals((String)"Binding deep nested properties using annotation", (Object)couple.first.getAddress().getStreetAddress(), (Object)form.firstStreetField.getValue());
        Assert.assertEquals((String)"Binding parallel deep nested properties using annotation", (Object)couple.second.getAddress().getStreetAddress(), (Object)form.secondStreetField.getValue());
        form.firstStreetField.setValue(second.getAddress().getStreetAddress());
        Assert.assertEquals((String)"Updating value in deep nested properties", (Object)form.firstStreetField.getValue(), (Object)first.getAddress().getStreetAddress());
    }

    @Test
    public void bindInstanceFields_circular() {
        BindDeepNestingFieldsWithCircularStructure form = new BindDeepNestingFieldsWithCircularStructure();
        Binder binder = new Binder(NestingStructure.class, true);
        binder.bindInstanceFields((Object)form);
        NestingStructure parent = new NestingStructure();
        parent.setName("parent");
        NestingStructure child = new NestingStructure();
        child.setName("child");
        parent.setChild(child);
        NestingStructure grandchild = new NestingStructure();
        grandchild.setName("grandchild");
        child.setChild(grandchild);
        NestingStructure root = grandchild;
        for (int i = 1; i < 15; ++i) {
            NestingStructure ns = new NestingStructure();
            ns.setName("great " + root.getName());
            root.setChild(ns);
            root = ns;
        }
        binder.setBean((Object)parent);
        Assert.assertEquals((Object)child.getName(), (Object)form.childName.getValue());
        Assert.assertEquals((Object)grandchild.getName(), (Object)form.grandchildName.getValue());
        Assert.assertNotNull((String)"Reading nested properties within default supported nested depth (max 10 levels)", (Object)form.eighthLevelGrandchildName);
        Assert.assertNull((String)"By default, only 10 levels of nesting properties are scanned.", (Object)form.distantGreatGrandchildName);
    }

    @Test
    public void bindInstanceFields_customNestingLevel() {
        BindDeepNestingFieldsWithCircularStructure form = new BindDeepNestingFieldsWithCircularStructure();
        int customScanningDepth = 5;
        PropertyFilterDefinition shallowFilter = new PropertyFilterDefinition(customScanningDepth, Arrays.asList("java.lang"));
        Binder binder = new Binder(BeanPropertySet.get(NestingStructure.class, (boolean)true, (PropertyFilterDefinition)shallowFilter));
        binder.bindInstanceFields((Object)form);
        NestingStructure parent = new NestingStructure();
        parent.setName("parent");
        NestingStructure child = new NestingStructure();
        child.setName("child");
        parent.setChild(child);
        NestingStructure grandchild = new NestingStructure();
        grandchild.setName("grandchild");
        child.setChild(grandchild);
        NestingStructure root = grandchild;
        for (int i = 1; i < 15; ++i) {
            NestingStructure ns = new NestingStructure();
            ns.setName("great " + root.getName());
            root.setChild(ns);
            root = ns;
        }
        binder.setBean((Object)parent);
        Assert.assertEquals((Object)child.getName(), (Object)form.childName.getValue());
        Assert.assertEquals((String)"Reading 3rd level nesting works when custom scanning depth is 5", (Object)grandchild.getName(), (Object)form.grandchildName.getValue());
        Assert.assertNull((String)"Reading eighth level nesting doesn't work when custom scanning depth is 5", (Object)form.eighthLevelGrandchildName);
    }

    @Test
    public void bindInstanceFields_bindNotBoundFieldsOnly_customBindingIsNotReplaced() {
        BindAllFields form = new BindAllFields();
        Binder binder = new Binder(Person.class);
        TextField name = new TextField();
        form.firstName = name;
        binder.forField((HasValue)form.firstName).withValidator((Validator)new StringLengthValidator("Name is invalid", Integer.valueOf(3), Integer.valueOf(10))).bind("firstName");
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        String personName = "foo";
        person.setFirstName(personName);
        person.setBirthDate(LocalDate.now());
        binder.setBean((Object)person);
        Assert.assertEquals((Object)person.getFirstName(), (Object)form.firstName.getValue());
        Assert.assertEquals((Object)person.getBirthDate(), (Object)form.birthDate.getValue());
        Assert.assertEquals((Object)name, (Object)form.firstName);
        form.birthDate.setValue((Temporal)person.getBirthDate().plusDays(345L));
        Assert.assertEquals((Object)form.birthDate.getValue(), (Object)person.getBirthDate());
        form.firstName.setValue("aa");
        Assert.assertEquals((Object)personName, (Object)person.getFirstName());
        Assert.assertFalse((boolean)binder.validate().isOk());
    }

    @Test
    public void bindInstanceFields_fieldsAreConfigured_customBindingIsNotReplaced() {
        BindWithNoFieldInPerson form = new BindWithNoFieldInPerson();
        Binder binder = new Binder(Person.class);
        TextField name = new TextField();
        form.firstName = name;
        binder.forField((HasValue)form.firstName).withValidator((Validator)new StringLengthValidator("Name is invalid", Integer.valueOf(3), Integer.valueOf(10))).bind("firstName");
        TextField ageField = new TextField();
        form.noFieldInPerson = ageField;
        binder.forField((HasValue)form.noFieldInPerson).withConverter((Converter)new StringToIntegerConverter("")).bind(Person::getAge, Person::setAge);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        String personName = "foo";
        int age = 11;
        person.setFirstName(personName);
        person.setAge(age);
        binder.setBean((Object)person);
        Assert.assertEquals((Object)person.getFirstName(), (Object)form.firstName.getValue());
        Assert.assertEquals((Object)String.valueOf(person.getAge()), (Object)form.noFieldInPerson.getValue());
        Assert.assertEquals((Object)name, (Object)form.firstName);
        Assert.assertEquals((Object)ageField, (Object)form.noFieldInPerson);
        form.noFieldInPerson.setValue(String.valueOf(age += 56));
        Assert.assertEquals((Object)form.noFieldInPerson.getValue(), (Object)String.valueOf(person.getAge()));
        form.firstName.setValue("aa");
        Assert.assertEquals((Object)personName, (Object)person.getFirstName());
        Assert.assertFalse((boolean)binder.validate().isOk());
    }

    @Test
    public void bindInstanceFields_preconfiguredFieldNotBoundToPropertyPreserved() {
        BindOneFieldRequiresConverter form = new BindOneFieldRequiresConverter();
        form.age = new TextField();
        form.firstName = new TextField();
        Binder binder = new Binder(Person.class);
        binder.forField((HasValue)form.age).withConverter((SerializableFunction & Serializable)str -> Integer.parseInt(str) / 2, (SerializableFunction & Serializable)integer -> Integer.toString(integer * 2)).bind(Person::getAge, Person::setAge);
        binder.bindInstanceFields((Object)form);
        Person person = new Person();
        person.setFirstName("first");
        person.setAge(45);
        binder.setBean((Object)person);
        Assert.assertEquals((Object)"90", (Object)form.age.getValue());
    }

    @Test
    public void bindInstanceFields_explicitelyBoundFieldAndNotBoundField() {
        BindOnlyOneField form = new BindOnlyOneField();
        Binder binder = new Binder(Person.class);
        binder.forField((HasValue)new TextField()).bind("firstName");
        binder.bindInstanceFields((Object)form);
    }

    @Test
    public void bindInstanceFields_tentativelyBoundFieldAndNotBoundField() {
        BindOnlyOneField form = new BindOnlyOneField();
        Binder binder = new Binder(Person.class);
        TextField field = new TextField();
        form.firstName = field;
        binder.forMemberField((HasValue)field);
        binder.bindInstanceFields((Object)form);
    }

    @Test
    public void bindInstanceFields_fieldsNeedConversion_knownConvertersApplied() {
        BindAutomaticConverter form = new BindAutomaticConverter();
        form.stringToInteger = new TextField();
        form.localDateToDate = new DateField();
        form.stringToBigDecimal = new TextField();
        form.stringToBigInteger = new TextField();
        form.stringToBoolean = new TextField();
        form.stringToPrimitiveBoolean = new TextField();
        form.stringToDouble = new TextField();
        form.stringToPrimitiveDouble = new TextField();
        form.stringToFloat = new TextField();
        form.stringToPrimitiveFloat = new TextField();
        form.stringToInteger = new TextField();
        form.stringToPrimitiveInteger = new TextField();
        form.stringToLong = new TextField();
        form.stringToPrimitiveLong = new TextField();
        form.stringToUUID = new TextField();
        Binder binder = new Binder(ConvertibleValues.class);
        binder.bindInstanceFields((Object)form);
        LocalDate now = LocalDate.of(2022, 3, 27);
        UUID uuid = UUID.randomUUID();
        ConvertibleValues data = new ConvertibleValues();
        data.setStringToBigDecimal(new BigDecimal("20.23"));
        data.setStringToBigInteger(new BigInteger("30"));
        data.setStringToDouble(40.56);
        data.setStringToPrimitiveDouble(50.78);
        data.setStringToFloat(Float.valueOf(60.23f));
        data.setStringToPrimitiveFloat(70.12f);
        data.setStringToInteger(80);
        data.setStringToPrimitiveInteger(90);
        data.setStringToLong(100L);
        data.setStringToPrimitiveLong(110L);
        data.setStringToBoolean(true);
        data.setStringToPrimitiveBoolean(false);
        data.setLocalDateToDate(Date.valueOf(now));
        data.setStringToUUID(uuid);
        binder.setBean((Object)data);
        Assert.assertEquals((Object)"20.23", (Object)form.stringToBigDecimal.getValue());
        Assert.assertEquals((Object)"30", (Object)form.stringToBigInteger.getValue());
        Assert.assertEquals((Object)"40.56", (Object)form.stringToDouble.getValue());
        Assert.assertEquals((Object)"50.78", (Object)form.stringToPrimitiveDouble.getValue());
        Assert.assertEquals((Object)"60.23", (Object)form.stringToFloat.getValue());
        Assert.assertEquals((Object)"70.12", (Object)form.stringToPrimitiveFloat.getValue());
        Assert.assertEquals((Object)"80", (Object)form.stringToInteger.getValue());
        Assert.assertEquals((Object)"90", (Object)form.stringToPrimitiveInteger.getValue());
        Assert.assertEquals((Object)"100", (Object)form.stringToLong.getValue());
        Assert.assertEquals((Object)"110", (Object)form.stringToPrimitiveLong.getValue());
        Assert.assertEquals((Object)"true", (Object)form.stringToBoolean.getValue());
        Assert.assertEquals((Object)"false", (Object)form.stringToPrimitiveBoolean.getValue());
        Assert.assertEquals((Object)now, (Object)form.localDateToDate.getValue());
        Assert.assertEquals((Object)uuid.toString(), (Object)form.stringToUUID.getValue());
    }

    @Test
    public void bindInstanceFields_fieldsNeedConversion_nullRepresentationIsConfigured() {
        BindAutomaticConverter form = new BindAutomaticConverter();
        form.stringToInteger = new TextField(){

            public String getEmptyValue() {
                return "EMPTY";
            }
        };
        Binder binder = new Binder(ConvertibleValues.class);
        binder.bindInstanceFields((Object)form);
        ConvertibleValues data = new ConvertibleValues();
        binder.setBean((Object)data);
        Assert.assertEquals((Object)"EMPTY", (Object)form.stringToInteger.getValue());
    }

    @Test
    public void bindInstanceFields_incompleteBinding_converterNotAppliedAutomatically() {
        BindOneFieldRequiresConverter form = new BindOneFieldRequiresConverter();
        form.age = new TextField();
        Binder binder = new Binder(Person.class);
        Binder.BindingBuilder ageBinding = binder.forField((HasValue)form.age).withConverter((SerializableFunction & Serializable)str -> Integer.parseInt(str) / 2, (SerializableFunction & Serializable)integer -> Integer.toString(integer * 2));
        binder.bindInstanceFields((Object)form);
        Assert.assertFalse((String)"Expecting incomplete binding to be ignored by Binder, but field was bound", (boolean)binder.getBinding("age").isPresent());
        ageBinding.bind(Person::getAge, Person::setAge);
        Person person = new Person();
        person.setAge(45);
        binder.setBean((Object)person);
        Assert.assertEquals((Object)"90", (Object)form.age.getValue());
    }

    final class NestingStructure {
        NestingStructure child;
        String name;

        NestingStructure() {
        }

        public NestingStructure getChild() {
            return this.child;
        }

        public void setChild(NestingStructure child) {
            this.child = child;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    static final class Couple {
        Person first;
        Person second;

        Couple() {
        }

        public Person getFirst() {
            return this.first;
        }

        public Person getSecond() {
            return this.second;
        }

        public void setFirst(Person first) {
            this.first = first;
        }

        public void setSecond(Person second) {
            this.second = second;
        }
    }

    public static class CustomField<T>
    extends AbstractField<T> {
        private T value;

        public T getValue() {
            return this.value;
        }

        protected void doSetValue(T value) {
            this.value = value;
        }
    }

    public static class ComplexGeneric<U, V, S>
    extends CustomField<V> {
    }

    public static class Generic<T>
    extends ComplexGeneric<Boolean, String, T> {
    }

    public static class ComplexHierarchy
    extends Generic<Long> {
    }

    public static class IntegerTextField
    extends CustomField<Integer> {
    }

    public static class NoDefaultCtor
    extends TextField {
        public NoDefaultCtor(int arg) {
        }
    }

    public static class BindComplextHierarchyGenericType
    extends FormLayout {
        private ComplexHierarchy firstName;
    }

    public static class BindNonInstantiatableType
    extends FormLayout {
        private NoDefaultCtor firstName;
    }

    public static class BindAbstract
    extends FormLayout {
        private AbstractTextField firstName;
    }

    public static class BindRaw
    extends FormLayout {
        private CustomField firstName;
    }

    public static class BindAutomaticConverter
    extends FormLayout {
        private DateField localDateToDate;
        private TextField stringToBigDecimal;
        private TextField stringToBigInteger;
        private TextField stringToBoolean;
        private TextField stringToPrimitiveBoolean;
        private TextField stringToDouble;
        private TextField stringToPrimitiveDouble;
        private TextField stringToFloat;
        private TextField stringToPrimitiveFloat;
        private TextField stringToInteger;
        private TextField stringToPrimitiveInteger;
        private TextField stringToLong;
        private TextField stringToPrimitiveLong;
        private TextField stringToUUID;
    }

    public static class BindGeneric<T>
    extends FormLayout {
        private CustomField<T> firstName;
    }

    public static class BindOneFieldRequiresConverter
    extends FormLayout {
        private TextField firstName;
        private TextField age;
    }

    public static class BindWrongTypeParameterField
    extends FormLayout {
        private IntegerTextField firstName;
    }

    public static class BindGenericWrongTypeParameterField
    extends FormLayout {
        private CustomField<Boolean> firstName;
    }

    public static class BindGenericField
    extends FormLayout {
        private CustomField<String> firstName;
    }

    public static class BindFieldHasWrongType
    extends FormLayout {
        private String firstName;
        private DateField birthDate;
    }

    public static class BindWithNoFieldInPerson
    extends FormLayout {
        private TextField firstName;
        private DateField birthDate;
        private TextField noFieldInPerson;
    }

    public static class BindOnlyOneField
    extends FormLayout {
        private TextField firstName;
        private TextField noFieldInPerson;
    }

    public static class BindDeepNestingFieldsWithCircularStructure
    extends FormLayout {
        @PropertyId(value="child.name")
        private TextField childName;
        @PropertyId(value="child.child.name")
        private TextField grandchildName;
        @PropertyId(value="child.child.child.child.child.child.child.child.name")
        private TextField eighthLevelGrandchildName;
        @PropertyId(value="child.child.child.child.child.child.child.child.child.child.child.child.child.name")
        private TextField distantGreatGrandchildName;
    }

    public static class BindDeepNestedFieldsUsingAnnotation
    extends FormLayout {
        @PropertyId(value="first.address.streetAddress")
        private TextField firstStreetField;
        @PropertyId(value="second.address.streetAddress")
        private TextField secondStreetField;
    }

    public static class BindNestedFieldsUsingAnnotation
    extends FormLayout {
        @PropertyId(value="address.streetAddress")
        private TextField streetAddressField;
    }

    public static class BindFieldsUsingAnnotation
    extends FormLayout {
        @PropertyId(value="firstName")
        private TextField nameField;
        @PropertyId(value="birthDate")
        private DateField birthDateField;
    }

    public static class BindAllFields
    extends FormLayout {
        private TextField firstName;
        private DateField birthDate;
    }
}

