/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.data.PropertyDefinition;
import com.vaadin.data.PropertySet;
import com.vaadin.data.ValueProvider;
import com.vaadin.server.Setter;
import com.vaadin.ui.TextField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class BinderCustomPropertySetTest {
    @Test
    public void testBindByString() {
        TextField field = new TextField();
        HashMap map = new HashMap();
        Binder binder = Binder.withPropertySet((PropertySet)new MapPropertySet());
        binder.bind((HasValue)field, "key");
        binder.setBean(map);
        field.setValue("value");
        Assert.assertEquals((String)"Field value should propagate to the corresponding key in the map", (Object)"value", map.get("key"));
    }

    @Test
    public void testBindInstanceFields() {
        HashMap map = new HashMap();
        Binder binder = Binder.withPropertySet((PropertySet)new MapPropertySet());
        InstanceFields instanceFields = new InstanceFields();
        binder.bindInstanceFields((Object)instanceFields);
        Assert.assertNotNull((String)"Field corresponding to supported property name should be bound", (Object)instanceFields.one);
        Assert.assertNull((String)"Field corresponding to unsupported property name should be ignored", (Object)instanceFields.another);
        binder.setBean(map);
        instanceFields.one.setValue("value");
        Assert.assertEquals((String)"Field value should propagate to the corresponding key in the map", (Object)"value", map.get("one"));
    }

    public static class InstanceFields {
        private TextField one;
        private TextField another;
    }

    public static class MapPropertySet
    implements PropertySet<Map<String, String>> {
        public Stream<PropertyDefinition<Map<String, String>, ?>> getProperties() {
            return Stream.of("one", "two", "three").map(this::createProperty);
        }

        public Optional<PropertyDefinition<Map<String, String>, ?>> getProperty(String name) {
            return Optional.of(this.createProperty(name));
        }

        private PropertyDefinition<Map<String, String>, ?> createProperty(String name) {
            return new MapPropertyDefinition(this, name);
        }
    }

    public static class MapPropertyDefinition
    implements PropertyDefinition<Map<String, String>, String> {
        private MapPropertySet propertySet;
        private String name;

        public MapPropertyDefinition(MapPropertySet propertySet, String name) {
            this.propertySet = propertySet;
            this.name = name;
        }

        public ValueProvider<Map<String, String>, String> getGetter() {
            return (ValueProvider & Serializable)map -> (String)map.get(this.name);
        }

        public Optional<Setter<Map<String, String>, String>> getSetter() {
            return Optional.of((Setter & Serializable)(map, value) -> {
                if (value == null) {
                    map.remove(this.name);
                } else {
                    map.put(this.name, value);
                }
            });
        }

        public Class<String> getType() {
            return String.class;
        }

        public Class<?> getPropertyHolderType() {
            return Map.class;
        }

        public String getName() {
            return this.name;
        }

        public PropertySet<Map<String, String>> getPropertySet() {
            return this.propertySet;
        }

        public String getCaption() {
            return this.name.toUpperCase(Locale.ROOT);
        }
    }
}

