/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data;

import com.vaadin.data.BeanPropertySet;
import com.vaadin.data.PropertyDefinition;
import com.vaadin.data.PropertyFilterDefinition;
import com.vaadin.data.PropertySet;
import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.bov.Person;
import com.vaadin.tests.data.bean.Address;
import com.vaadin.tests.data.bean.Country;
import com.vaadin.tests.data.bean.FatherAndSon;
import com.vaadin.tests.data.bean.Sex;
import com.vaadin.tests.server.ClassesSerializableTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import org.junit.Test;

public class BeanPropertySetTest {
    @Test
    public void testSerializeDeserialize_propertySet() throws Exception {
        PropertySet originalPropertySet = BeanPropertySet.get(Person.class);
        PropertySet deserializedPropertySet = ClassesSerializableTest.serializeAndDeserialize(originalPropertySet);
        this.comparePropertySet(originalPropertySet, deserializedPropertySet, "Deserialized instance should be the same as the original");
    }

    private void comparePropertySet(PropertySet<?> propertySetA, PropertySet<?> propertySetB, String message) {
        PropertyDefinition[] propertiesA = (PropertyDefinition[])propertySetA.getProperties().sorted(Comparator.comparing(PropertyDefinition::getName)).toArray(PropertyDefinition[]::new);
        PropertyDefinition[] propertiesB = (PropertyDefinition[])propertySetA.getProperties().sorted(Comparator.comparing(PropertyDefinition::getName)).toArray(PropertyDefinition[]::new);
        Assert.assertEquals((String)message, (long)propertiesA.length, (long)propertiesB.length);
        for (int i = 0; i < propertiesB.length; ++i) {
            Assert.assertSame((String)message, (Object)propertiesA[i], (Object)propertiesB[i]);
        }
    }

    @Test
    public void testSerializeDeserialize_propertySet_cacheCleared() throws Exception {
        PropertySet originalPropertySet = BeanPropertySet.get(Person.class);
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bs);
        out.writeObject(originalPropertySet);
        byte[] data = bs.toByteArray();
        Field instancesField = BeanPropertySet.class.getDeclaredField("INSTANCES");
        instancesField.setAccessible(true);
        Map instances = (Map)instancesField.get(null);
        instances.clear();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));
        PropertySet deserializedPropertySet = (PropertySet)in.readObject();
        this.comparePropertySet(BeanPropertySet.get(Person.class), deserializedPropertySet, "Deserialized instance should be the same as in the cache");
        Assert.assertNotSame((String)"Deserialized instance should not be the same as the original", (Object)originalPropertySet, (Object)deserializedPropertySet);
    }

    @Test
    public void testSerializeDeserialize_propertyDefinition() throws Exception {
        PropertyDefinition definition = (PropertyDefinition)BeanPropertySet.get(Person.class).getProperty("born").orElseThrow(RuntimeException::new);
        PropertyDefinition deserializedDefinition = ClassesSerializableTest.serializeAndDeserialize(definition);
        ValueProvider getter = deserializedDefinition.getGetter();
        Person person = new Person("Milennial", 2000);
        Integer age = (Integer)getter.apply((Object)person);
        Assert.assertEquals((String)"Deserialized definition should be functional", (Object)2000, (Object)age);
        Assert.assertSame((String)"Deserialized instance should be the same as in the cache", BeanPropertySet.get(Person.class).getProperty("born").orElseThrow(RuntimeException::new), (Object)deserializedDefinition);
    }

    @Test
    public void testSerializeDeserialize_nestedPropertyDefinition() throws Exception {
        PropertyDefinition definition = (PropertyDefinition)BeanPropertySet.get(com.vaadin.tests.data.bean.Person.class, (boolean)true, (PropertyFilterDefinition)PropertyFilterDefinition.getDefaultFilter()).getProperty("address.postalCode").orElseThrow(AssertionFailedError::new);
        PropertyDefinition deserializedDefinition = ClassesSerializableTest.serializeAndDeserialize(definition);
        ValueProvider getter = deserializedDefinition.getGetter();
        Address address = new Address("Ruukinkatu 2-4", 20540, "Turku", Country.FINLAND);
        com.vaadin.tests.data.bean.Person person = new com.vaadin.tests.data.bean.Person("Jon", "Doe", "jon.doe@vaadin.com", 32, Sex.MALE, address);
        Integer postalCode = (Integer)getter.apply((Object)person);
        Assert.assertEquals((String)"Deserialized definition should be functional", (Object)address.getPostalCode(), (Object)postalCode);
    }

    @Test
    public void nestedPropertyDefinition_samePropertyNameOnMultipleLevels() {
        PropertyDefinition definition = (PropertyDefinition)BeanPropertySet.get(FatherAndSon.class).getProperty("father.father.firstName").orElseThrow(RuntimeException::new);
        ValueProvider getter = definition.getGetter();
        FatherAndSon grandFather = new FatherAndSon("Grand Old Jon", "Doe", null, null);
        FatherAndSon father = new FatherAndSon("Old Jon", "Doe", grandFather, null);
        FatherAndSon son = new FatherAndSon("Jon", "Doe", father, null);
        String firstName = (String)getter.apply((Object)son);
        Assert.assertEquals((Object)grandFather.getFirstName(), (Object)firstName);
    }

    @Test(expected=NullPointerException.class)
    public void nestedPropertyDefinition_propertyChainBroken() {
        PropertyDefinition definition = (PropertyDefinition)BeanPropertySet.get(FatherAndSon.class).getProperty("father.firstName").orElseThrow(RuntimeException::new);
        ValueProvider getter = definition.getGetter();
        getter.apply((Object)new FatherAndSon("Jon", "Doe", null, null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void nestedPropertyDefinition_invalidPropertyNameInChain() {
        BeanPropertySet.get(FatherAndSon.class).getProperty("grandfather.firstName");
    }

    @Test(expected=IllegalArgumentException.class)
    public void nestedPropertyDefinition_invalidPropertyNameAtChainEnd() {
        BeanPropertySet.get(FatherAndSon.class).getProperty("father.age");
    }

    @Test
    public void properties() {
        PropertySet propertySet = BeanPropertySet.get(Person.class);
        Set propertyNames = propertySet.getProperties().map(PropertyDefinition::getName).collect(Collectors.toSet());
        Assert.assertEquals(new HashSet<String>(Arrays.asList("name", "born")), propertyNames);
    }

    @Test
    public void get_beanImplementsSameInterfaceSeveralTimes_interfacePropertyIsNotDuplicated() {
        PropertySet set = BeanPropertySet.get(Iface3.class, (boolean)false, (PropertyFilterDefinition)PropertyFilterDefinition.getDefaultFilter());
        List defs = set.getProperties().collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)defs.size());
        Assert.assertEquals((Object)"name", (Object)((PropertyDefinition)defs.get(0)).getName());
    }

    @Test
    public void includesDefaultMethodsFromInterfaces() {
        PropertySet set = BeanPropertySet.get(MyClass.class);
        List defs = set.getProperties().collect(Collectors.toList());
        Assert.assertEquals((String)"Unexpected amount of property definitions,", (long)4L, (long)defs.size());
        Assert.assertEquals((String)"Unexpected first definition name,", (Object)"name", (Object)((PropertyDefinition)defs.get(0)).getName());
        Assert.assertEquals((String)"Unexpected first definition type,", String.class, (Object)((PropertyDefinition)defs.get(0)).getType());
        Assert.assertEquals((String)"Unexpected second definition name,", (Object)"lastName", (Object)((PropertyDefinition)defs.get(1)).getName());
        Assert.assertEquals((String)"Unexpected second definition type,", String.class, (Object)((PropertyDefinition)defs.get(1)).getType());
        Assert.assertEquals((String)"Unexpected third definition name,", (Object)"firstName", (Object)((PropertyDefinition)defs.get(2)).getName());
        Assert.assertEquals((String)"Unexpected third definition type,", String.class, (Object)((PropertyDefinition)defs.get(2)).getType());
        Assert.assertEquals((String)"Unexpected fourth definition name,", (Object)"something", (Object)((PropertyDefinition)defs.get(3)).getName());
        Assert.assertEquals((String)"Unexpected fourth definition type,", String.class, (Object)((PropertyDefinition)defs.get(3)).getType());
    }

    public class MyClass
    implements HasName {
        private String lastName;
        private String firstName;

        @Override
        public String getLastName() {
            return this.lastName;
        }

        @Override
        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public String getFirstName() {
            return this.firstName;
        }

        @Override
        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }
    }

    public static interface HasName
    extends HasSomething {
        default public String getName() {
            return this.getLastName() + ", " + this.getFirstName();
        }

        default public void setName(String name) {
            Matcher matcher = Pattern.compile("^(.+), (.+)$").matcher(name);
            this.setLastName(matcher.group(1));
            this.setFirstName(matcher.group(2));
        }

        public String getLastName();

        public void setLastName(String var1);

        public String getFirstName();

        public void setFirstName(String var1);
    }

    public static interface HasSomething {
        default public String getSomething() {
            return "something";
        }

        default public void setSomething(String something) {
        }
    }

    static interface Iface {
        public String getName();
    }

    static interface Iface2
    extends Iface {
    }

    static interface Iface3
    extends Iface2,
    Iface {
    }
}

