/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.data;

import com.vaadin.data.BeanValidationBinder;
import com.vaadin.data.Binder;
import com.vaadin.data.BinderInstanceFieldTest;
import com.vaadin.data.BinderTestBase;
import com.vaadin.data.BinderValidationStatus;
import com.vaadin.data.BindingValidationStatus;
import com.vaadin.data.Converter;
import com.vaadin.data.HasValue;
import com.vaadin.data.converter.StringToIntegerConverter;
import com.vaadin.server.SerializableFunction;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.tests.data.bean.BeanToValidate;
import com.vaadin.ui.CheckBoxGroup;
import com.vaadin.ui.TextField;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.NotEmpty;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BeanBinderTest
extends BinderTestBase<Binder<BeanToValidate>, BeanToValidate> {
    @Before
    public void setUp() {
        this.binder = new BeanValidationBinder(BeanToValidate.class);
        this.item = new BeanToValidate();
        ((BeanToValidate)this.item).setFirstname("Johannes");
        ((BeanToValidate)this.item).setAge(32);
    }

    @Test
    public void bindInstanceFields_parameters_type_erased() {
        Binder otherBinder = new Binder(TestBean.class);
        TestClass testClass = new TestClass();
        otherBinder.forField((HasValue)testClass.number).withConverter((Converter)new StringToIntegerConverter("")).bind("number");
        otherBinder.bindInstanceFields((Object)testClass);
        BeanBinderTest.testSerialization(otherBinder);
    }

    @Test
    public void bindInstanceFields_automatically_binds_incomplete_forMemberField_bindings() {
        Binder otherBinder = new Binder(TestBean.class);
        TestClass testClass = new TestClass();
        otherBinder.forMemberField((HasValue)testClass.number).withConverter((Converter)new StringToIntegerConverter(""));
        otherBinder.bindInstanceFields((Object)testClass);
        TestBean bean = new TestBean();
        otherBinder.setBean((Object)bean);
        testClass.number.setValue("50");
        Assert.assertEquals((long)50L, (long)bean.number);
        BeanBinderTest.testSerialization(otherBinder);
    }

    @Test(expected=IllegalStateException.class)
    public void bindInstanceFields_does_not_automatically_bind_incomplete_forField_bindings() {
        Binder otherBinder = new Binder(TestBean.class);
        TestClass testClass = new TestClass();
        otherBinder.forField((HasValue)testClass.number).withConverter((Converter)new StringToIntegerConverter(""));
        otherBinder.bindInstanceFields((Object)testClass);
        otherBinder.setBean((Object)new TestBean());
    }

    @Test(expected=IllegalStateException.class)
    public void bindInstanceFields_throw_if_no_fields_bound() {
        Binder otherBinder = new Binder(TestBean.class);
        TestClassWithoutFields testClass = new TestClassWithoutFields();
        otherBinder.bindInstanceFields((Object)testClass);
    }

    @Test
    public void bindInstanceFields_does_not_throw_if_fields_are_bound_manually() {
        PersonForm form = new PersonForm();
        Binder binder = new Binder(Person.class);
        binder.forMemberField((HasValue)form.mydate).withConverter((SerializableFunction & Serializable)str -> LocalDate.now(), (SerializableFunction & Serializable)date -> "Hello").bind("mydate");
        binder.bindInstanceFields((Object)form);
    }

    @Test
    public void bindInstanceFields_does_not_throw_if_there_are_incomplete_bindings() {
        PersonForm form = new PersonForm();
        Binder binder = new Binder(Person.class);
        binder.forMemberField((HasValue)form.mydate).withConverter((SerializableFunction & Serializable)str -> LocalDate.now(), (SerializableFunction & Serializable)date -> "Hello");
        binder.bindInstanceFields((Object)form);
    }

    @Test(expected=IllegalStateException.class)
    public void incomplete_forMemberField_bindings() {
        Binder otherBinder = new Binder(TestBean.class);
        TestClass testClass = new TestClass();
        otherBinder.forMemberField((HasValue)testClass.number).withConverter((Converter)new StringToIntegerConverter(""));
        otherBinder.setBean((Object)new TestBean());
    }

    @Test
    public void fieldBound_bindBean_fieldValueUpdated() {
        this.binder.bind((HasValue)this.nameField, "firstname");
        this.binder.setBean((Object)((BeanToValidate)this.item));
        Assert.assertEquals((Object)"Johannes", (Object)this.nameField.getValue());
    }

    @Test
    public void beanBound_bindField_fieldValueUpdated() {
        this.binder.setBean((Object)((BeanToValidate)this.item));
        this.binder.bind((HasValue)this.nameField, "firstname");
        Assert.assertEquals((Object)"Johannes", (Object)this.nameField.getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void bindInvalidPropertyName_throws() {
        this.binder.bind((HasValue)this.nameField, "firstnaem");
    }

    @Test(expected=NullPointerException.class)
    public void bindNullPropertyName_throws() {
        this.binder.bind((HasValue)this.nameField, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void bindNonReadableProperty_throws() {
        this.binder.bind((HasValue)this.nameField, "writeOnlyProperty");
    }

    @Test
    public void beanBound_setValidFieldValue_propertyValueChanged() {
        this.binder.setBean((Object)((BeanToValidate)this.item));
        this.binder.bind((HasValue)this.nameField, "firstname");
        this.nameField.setValue("Henri");
        Assert.assertEquals((Object)"Henri", (Object)((BeanToValidate)this.item).getFirstname());
    }

    @Test
    public void readOnlyPropertyBound_setFieldValue_ignored() {
        this.binder.bind((HasValue)this.nameField, "readOnlyProperty");
        this.binder.setBean((Object)((BeanToValidate)this.item));
        String propertyValue = ((BeanToValidate)this.item).getReadOnlyProperty();
        this.nameField.setValue("Foo");
        Assert.assertEquals((Object)propertyValue, (Object)((BeanToValidate)this.item).getReadOnlyProperty());
    }

    @Test
    public void bindReadOnlyPropertyShouldMarkFieldAsReadonly() {
        this.binder.bind((HasValue)this.nameField, "readOnlyProperty");
        Assert.assertTrue((String)"Name field should be readonly", (boolean)this.nameField.isReadOnly());
    }

    @Test
    public void setReadonlyShouldIgnoreBindingsForReadOnlyProperties() {
        this.binder.bind((HasValue)this.nameField, "readOnlyProperty");
        this.binder.setReadOnly(true);
        Assert.assertTrue((String)"Name field should be ignored and be readonly", (boolean)this.nameField.isReadOnly());
        this.binder.setReadOnly(false);
        Assert.assertTrue((String)"Name field should be ignored and be readonly", (boolean)this.nameField.isReadOnly());
        this.nameField.setReadOnly(false);
        this.binder.setReadOnly(true);
        Assert.assertFalse((String)"Name field should be ignored and not be readonly", (boolean)this.nameField.isReadOnly());
        this.binder.setReadOnly(false);
        Assert.assertFalse((String)"Name field should be ignored and not be readonly", (boolean)this.nameField.isReadOnly());
    }

    @Test
    public void beanBound_setInvalidFieldValue_validationError() {
        this.binder.setBean((Object)((BeanToValidate)this.item));
        this.binder.bind((HasValue)this.nameField, "firstname");
        this.nameField.setValue("H");
        Assert.assertEquals((Object)"Johannes", (Object)((BeanToValidate)this.item).getFirstname());
        this.assertInvalid((HasValue<?>)this.nameField, "size must be between 3 and 16");
    }

    @Test
    public void beanNotBound_setInvalidFieldValue_validationError() {
        this.binder.bind((HasValue)this.nameField, "firstname");
        this.nameField.setValue("H");
        this.assertInvalid((HasValue<?>)this.nameField, "size must be between 3 and 16");
    }

    @Test
    public void explicitValidatorAdded_setInvalidFieldValue_explicitValidatorRunFirst() {
        this.binder.forField((HasValue)this.nameField).withValidator((SerializablePredicate & Serializable)name -> name.startsWith("J"), "name must start with J").bind("firstname");
        this.nameField.setValue("A");
        this.assertInvalid((HasValue<?>)this.nameField, "name must start with J");
    }

    @Test
    public void explicitValidatorAdded_setInvalidFieldValue_beanValidatorRun() {
        this.binder.forField((HasValue)this.nameField).withValidator((SerializablePredicate & Serializable)name -> name.startsWith("J"), "name must start with J").bind("firstname");
        this.nameField.setValue("J");
        this.assertInvalid((HasValue<?>)this.nameField, "size must be between 3 and 16");
    }

    @Test(expected=ClassCastException.class)
    public void fieldWithIncompatibleTypeBound_bindBean_throws() {
        this.binder.bind((HasValue)this.ageField, "age");
        this.binder.setBean((Object)((BeanToValidate)this.item));
    }

    @Test(expected=ClassCastException.class)
    public void fieldWithIncompatibleTypeBound_loadBean_throws() {
        this.binder.bind((HasValue)this.ageField, "age");
        this.binder.readBean((Object)((BeanToValidate)this.item));
    }

    @Test(expected=ClassCastException.class)
    public void fieldWithIncompatibleTypeBound_saveBean_throws() throws Throwable {
        try {
            this.binder.bind((HasValue)this.ageField, "age");
            this.binder.writeBean((Object)((BeanToValidate)this.item));
        }
        catch (RuntimeException e) {
            throw e.getCause();
        }
    }

    @Test
    public void fieldWithConverterBound_bindBean_fieldValueUpdated() {
        this.binder.forField((HasValue)this.ageField).withConverter(Integer::valueOf, String::valueOf).bind("age");
        this.binder.setBean((Object)((BeanToValidate)this.item));
        Assert.assertEquals((Object)"32", (Object)this.ageField.getValue());
    }

    @Test(expected=ClassCastException.class)
    public void fieldWithInvalidConverterBound_bindBean_fieldValueUpdated() {
        this.binder.forField((HasValue)this.ageField).withConverter(Float::valueOf, String::valueOf).bind("age");
        this.binder.setBean((Object)((BeanToValidate)this.item));
        Assert.assertEquals((Object)"32", (Object)this.ageField.getValue());
    }

    @Test
    public void beanBinderWithBoxedType() {
        this.binder.forField((HasValue)this.ageField).withConverter(Integer::valueOf, String::valueOf).bind("age");
        this.binder.setBean((Object)((BeanToValidate)this.item));
        this.ageField.setValue(String.valueOf(20));
        Assert.assertEquals((long)20L, (long)((BeanToValidate)this.item).getAge());
    }

    @Test
    public void firstName_isNotNullConstraint_fieldIsRequired() {
        BeanValidationBinder binder = new BeanValidationBinder(RequiredConstraints.class);
        RequiredConstraints bean = new RequiredConstraints();
        TextField field = new TextField();
        binder.bind((HasValue)field, "firstname");
        binder.setBean((Object)bean);
        Assert.assertTrue((boolean)field.isRequiredIndicatorVisible());
        BeanBinderTest.testSerialization(binder);
    }

    @Test
    public void age_minSizeConstraint_fieldIsRequired() {
        BeanValidationBinder binder = new BeanValidationBinder(RequiredConstraints.class);
        RequiredConstraints bean = new RequiredConstraints();
        TextField field = new TextField();
        binder.bind((HasValue)field, "age");
        binder.setBean((Object)bean);
        Assert.assertTrue((boolean)field.isRequiredIndicatorVisible());
        BeanBinderTest.testSerialization(binder);
    }

    @Test
    public void lastName_minSizeConstraint_fieldIsRequired() {
        BeanValidationBinder binder = new BeanValidationBinder(RequiredConstraints.class);
        RequiredConstraints bean = new RequiredConstraints();
        TextField field = new TextField();
        binder.bind((HasValue)field, "lastname");
        binder.setBean((Object)bean);
        Assert.assertTrue((boolean)field.isRequiredIndicatorVisible());
        BeanBinderTest.testSerialization(binder);
    }

    @Test
    public void subfield_name_fieldIsRequired() {
        BeanValidationBinder binder = new BeanValidationBinder(RequiredConstraints.class);
        RequiredConstraints bean = new RequiredConstraints();
        bean.setSubfield(new RequiredConstraints.SubConstraint());
        TextField field = new TextField();
        binder.bind((HasValue)field, "subfield.name");
        binder.setBean((Object)bean);
        Assert.assertTrue((boolean)field.isRequiredIndicatorVisible());
        BeanBinderTest.testSerialization(binder);
    }

    @Test
    public void subsubfield_name_fieldIsRequired() {
        BeanValidationBinder binder = new BeanValidationBinder(RequiredConstraints.class);
        RequiredConstraints bean = new RequiredConstraints();
        RequiredConstraints.SubConstraint subfield = new RequiredConstraints.SubConstraint();
        subfield.setSubsub(new RequiredConstraints.SubSubConstraint());
        bean.setSubfield(subfield);
        TextField field = new TextField();
        binder.bind((HasValue)field, "subfield.subsub.value");
        binder.setBean((Object)bean);
        Assert.assertTrue((boolean)field.isRequiredIndicatorVisible());
        BeanBinderTest.testSerialization(binder);
    }

    @Test
    public void subfield_name_valueCanBeValidated() {
        BeanValidationBinder binder = new BeanValidationBinder(RequiredConstraints.class);
        TextField field = new TextField();
        binder.bind((HasValue)field, "subfield.name");
        RequiredConstraints bean = new RequiredConstraints();
        bean.setSubfield(new RequiredConstraints.SubConstraint());
        binder.setBean((Object)bean);
        Assert.assertFalse((boolean)binder.validate().isOk());
        field.setValue("overfive");
        Assert.assertTrue((boolean)binder.validate().isOk());
    }

    @Test
    public void subSubfield_name_valueCanBeValidated() {
        BeanValidationBinder binder = new BeanValidationBinder(RequiredConstraints.class);
        TextField field = new TextField();
        binder.bind((HasValue)field, "subfield.subsub.value");
        RequiredConstraints bean = new RequiredConstraints();
        RequiredConstraints.SubConstraint subfield = new RequiredConstraints.SubConstraint();
        bean.setSubfield(subfield);
        subfield.setSubsub(new RequiredConstraints.SubSubConstraint());
        binder.setBean((Object)bean);
        Assert.assertFalse((boolean)binder.validate().isOk());
        field.setValue("overtencharacters");
        Assert.assertTrue((boolean)binder.validate().isOk());
    }

    @Test
    public void interface_extension_with_overwritten_property() {
        Binder binder = new Binder(TestInterfaceWithOverwrittenMethod.class);
        BinderInstanceFieldTest.IntegerTextField field = new BinderInstanceFieldTest.IntegerTextField();
        binder.bind((HasValue)field, "property");
        TestInterfaceWithOverwrittenMethod bean = new TestInterfaceWithOverwrittenMethod(){

            @Override
            public int getProperty() {
                return 5;
            }
        };
        binder.setBean((Object)bean);
        Assert.assertEquals((Object)5, field.getValue());
    }

    private void assertInvalid(HasValue<?> field, String message) {
        BinderValidationStatus status = this.binder.validate();
        List errors = status.getFieldValidationErrors();
        Assert.assertEquals((long)1L, (long)errors.size());
        Assert.assertSame(field, (Object)((BindingValidationStatus)errors.get(0)).getField());
        Assert.assertEquals((Object)message, ((BindingValidationStatus)errors.get(0)).getMessage().get());
    }

    public static interface TestInterfaceWithOverwrittenMethod
    extends TestInterface {
        @Override
        public int getProperty();
    }

    public static interface TestInterface {
        public int getProperty();
    }

    public static class PersonForm {
        private TextField mydate = new TextField();
    }

    public static class Person {
        LocalDate mydate;

        public LocalDate getMydate() {
            return this.mydate;
        }

        public void setMydate(LocalDate mydate) {
            this.mydate = mydate;
        }
    }

    public static class RequiredConstraints
    implements Serializable {
        @NotNull
        @Max(value=10L)
        private @NotNull @Max(value=10L) String firstname;
        @Size(min=3, max=16)
        @Digits(integer=3, fraction=2)
        private @Size(min=3, max=16) @Digits(integer=3, fraction=2) String age;
        @NotEmpty
        private String lastname;
        private SubConstraint subfield;

        public String getFirstname() {
            return this.firstname;
        }

        public void setFirstname(String firstname) {
            this.firstname = firstname;
        }

        public String getAge() {
            return this.age;
        }

        public void setAge(String age) {
            this.age = age;
        }

        public String getLastname() {
            return this.lastname;
        }

        public void setLastname(String lastname) {
            this.lastname = lastname;
        }

        public SubConstraint getSubfield() {
            return this.subfield;
        }

        public void setSubfield(SubConstraint subfield) {
            this.subfield = subfield;
        }

        public static class SubSubConstraint
        implements Serializable {
            @Size(min=10)
            private @Size(min=10) String value;

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }

        public static class SubConstraint
        implements Serializable {
            @NotNull
            @NotEmpty
            @Size(min=5)
            private @NotNull @Size(min=5) String name;
            private SubSubConstraint subsub;

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public SubSubConstraint getSubsub() {
                return this.subsub;
            }

            public void setSubsub(SubSubConstraint subsub) {
                this.subsub = subsub;
            }
        }
    }

    private static class TestBean
    implements Serializable {
        private Set<TestEnum> enums;
        private int number;

        private TestBean() {
        }

        public Set<TestEnum> getEnums() {
            return this.enums;
        }

        public void setEnums(Set<TestEnum> enums) {
            this.enums = enums;
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }
    }

    private class TestClassWithoutFields {
        private TestClassWithoutFields() {
        }
    }

    private class TestClass {
        private CheckBoxGroup<TestEnum> enums;
        private TextField number = new TextField();

        private TestClass() {
        }
    }

    private static enum TestEnum {

    }
}

