/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui;

import java.util.HashSet;
import java.util.Set;

import com.vaadin.server.SerializablePredicate;

/**
 * Item enabled provider class for declarative support.
 * <p>
 * Provides a straightforward mapping between an item and its enable state.
 *
 * @param <T>
 *            item type
 */
class DeclarativeItemEnabledProvider<T> implements SerializablePredicate<T> {

    private Set<T> disabled = new HashSet<>();

    @Override
    public boolean test(T item) {
        return !disabled.contains(item);
    }

    /**
     * Adds the {@code item} to disabled items list.
     *
     * @param item
     *            a data item
     */
    protected void addDisabled(T item) {
        disabled.add(item);
    }

}
