/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.event.selection;

import java.lang.reflect.Method;

import com.vaadin.event.SerializableEventListener;
import com.vaadin.util.ReflectTools;

/**
 * A listener for listening for selection changes from a multiselection
 * component.
 *
 * @author Vaadin Ltd
 *
 * @since 8.0
 *
 * @param <T>
 *            the type of the selected item
 *
 * @see com.vaadin.data.SelectionModel.Multi
 * @see MultiSelectionEvent
 */
@FunctionalInterface
public interface MultiSelectionListener<T> extends SerializableEventListener {

    /** For internal use only. Might be removed in the future. */
    @Deprecated
    static final Method SELECTION_CHANGE_METHOD = ReflectTools.findMethod(
            MultiSelectionListener.class, "selectionChange",
            MultiSelectionEvent.class);

    /**
     * Invoked when the selection has changed by the user or programmatically.
     *
     * @param event
     *            the selection event, never {@code null}
     */
    public void selectionChange(MultiSelectionEvent<T> event);
}
