/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.data.provider;

/**
 * A data provider that supports programmatically setting a filter that will be
 * applied to all queries.
 *
 * @author Vaadin Ltd
 * @since 8.0
 *
 * @param <T>
 *            the data provider item type
 * @param <Q>
 *            the query filter type
 * @param <C>
 *            the configurable filter type
 */
public interface ConfigurableFilterDataProvider<T, Q, C>
        extends DataProvider<T, Q> {

    /**
     * Sets the filter to use for all queries handled by this data provider.
     *
     * @param filter
     *            the filter to set, or <code>null</code> to clear any
     *            previously set filter
     */
    public void setFilter(C filter);

}
