/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.dnd.event;

import java.util.Collection;

import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.ui.Html5File;
import com.vaadin.ui.dnd.FileDropHandler;

/**
 * File drop event that contains the collection of files dropped on a file drop
 * target.
 *
 * @param <T>
 *            Type of the file drop target component.
 * @author Vaadin Ltd
 * @see FileDropHandler
 * @since 8.1
 */
public class FileDropEvent<T extends AbstractComponent>
        extends Component.Event {

    private final Collection<Html5File> files;

    /**
     * Creates a file drop event.
     *
     * @param target
     *            The file drop target component.
     * @param files
     *            Collection of files.
     */
    public FileDropEvent(T target, Collection<Html5File> files) {
        super(target);

        this.files = files;
    }

    /**
     * Gets the collection of files dropped onto the file drop target component.
     *
     * @return Collection of files that were dropped onto the file drop target
     *         component.
     */
    public Collection<Html5File> getFiles() {
        return files;
    }
}
