/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.server;

import java.io.Serializable;

/**
 * Callback for generating the id for new connectors. A generator can be
 * registered to be used with an application by overriding
 * {@link VaadinService#initConnectorIdGenerator(java.util.List)} or by calling
 * {@link ServiceInitEvent#addConnectorIdGenerator(ConnectorIdGenerator)} from a
 * {@link VaadinServiceInitListener}.
 *
 * @author Vaadin Ltd
 * @since 8.1
 */
@FunctionalInterface
public interface ConnectorIdGenerator extends Serializable {
    /**
     * Generates a connector id for a connector.
     *
     * @param event
     *            the event object that has a reference to the connector and the
     *            session, not <code>null</code>
     * @return the connector id to use for the connector, not <code>null</code>
     */
    public String generateConnectorId(ConnectorIdGenerationEvent event);

    /**
     * Generates a connector id using the default logic by using
     * {@link VaadinSession#getNextConnectorId()}.
     *
     * @param event
     *            the event object that has a reference to the connector and the
     *            session, not <code>null</code>
     * @return the connector id to use for the connector, not <code>null</code>
     */
    public static String generateDefaultConnectorId(
            ConnectorIdGenerationEvent event) {
        assert event != null;
        return event.getSession().getNextConnectorId();
    }
}
