/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.data.provider;

import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.ui.Grid.Column;

/**
 * Helper classes with fluent API for constructing {@link GridSortOrder} lists.
 * When the sort order is ready to be passed on, calling {@link #build()} will
 * create the list of sort orders.
 *
 * @see GridSortOrder
 * @see #thenAsc(Column)
 * @see #thenDesc(Column)
 * @see #build()
 *
 * @param <T>
 *            the type of the grid
 * @since 8.0
 */
public class GridSortOrderBuilder<T>
        extends SortOrderBuilder<GridSortOrder<T>, Column<T, ?>> {

    @Override
    public GridSortOrderBuilder<T> thenAsc(Column<T, ?> by) {
        return (GridSortOrderBuilder<T>) super.thenAsc(by);
    }

    @Override
    public GridSortOrderBuilder<T> thenDesc(Column<T, ?> by) {
        return (GridSortOrderBuilder<T>) super.thenDesc(by);
    }

    @Override
    protected GridSortOrder<T> createSortOrder(Column<T, ?> by,
            SortDirection direction) {
        return new GridSortOrder<>(by, direction);
    }
}
