/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui.components.grid;

import java.util.stream.Stream;

import com.vaadin.data.provider.QuerySortOrder;
import com.vaadin.server.SerializableFunction;
import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.ui.Grid.Column;

/**
 * Generates the sort orders when rows are sorted by a column.
 *
 * @see Column#setSortOrderProvider
 *
 * @since 8.0
 * @author Vaadin Ltd
 */
@FunctionalInterface
public interface SortOrderProvider
        extends SerializableFunction<SortDirection, Stream<QuerySortOrder>> {

    /**
     * Generates the sort orders when rows are sorted by a column.
     *
     * @param sortDirection
     *            desired sort direction
     *
     * @return sort information
     */
    @Override
    public Stream<QuerySortOrder> apply(SortDirection sortDirection);

}
