/*
 * Copyright (C) 2000-2026 Vaadin Ltd
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
package com.vaadin.ui;

import com.vaadin.shared.ui.button.NativeButtonState;

@SuppressWarnings("serial")
public class NativeButton extends Button {

    public NativeButton() {
        super();
    }

    public NativeButton(String caption) {
        super(caption);
    }

    public NativeButton(String caption, ClickListener listener) {
        super(caption, listener);
    }

    @Override
    protected NativeButtonState getState() {
        return (NativeButtonState) super.getState();
    }

    @Override
    protected NativeButtonState getState(boolean markAsDirty) {
        return (NativeButtonState) super.getState(markAsDirty);
    }

}
