/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.util;

import com.vaadin.util.ReflectTools;
import java.io.Serializable;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ReflectToolsTest
implements Serializable {
    @Test
    public void findCommonBaseType_sameType() {
        Assert.assertSame(Number.class, (Object)ReflectTools.findCommonBaseType(Number.class, Number.class));
    }

    @Test
    public void findCommonBaseType_aExtendsB() {
        Assert.assertSame(Number.class, (Object)ReflectTools.findCommonBaseType(Integer.class, Number.class));
    }

    @Test
    public void findCommonBaseType_bExtendsA() {
        Assert.assertSame(Number.class, (Object)ReflectTools.findCommonBaseType(Number.class, Integer.class));
    }

    @Test
    public void findCommonBaseType_commonBase() {
        Assert.assertSame(Number.class, (Object)ReflectTools.findCommonBaseType(Double.class, Integer.class));
    }

    @Test
    public void findCommonBaseType_noCommonBase() {
        Assert.assertSame(Object.class, (Object)ReflectTools.findCommonBaseType(String.class, Number.class));
    }

    @Test
    public void getGenericInterfaceClasses() {
        List genericInterfaceTypes = ReflectTools.getGenericInterfaceTypes(HasInterface.class, TestInterface.class);
        Assert.assertArrayEquals((Object[])new Class[]{String.class}, (Object[])genericInterfaceTypes.toArray());
        genericInterfaceTypes = ReflectTools.getGenericInterfaceTypes(ChildInterface.class, TestInterface.class);
        Assert.assertArrayEquals((Object[])new Class[]{Boolean.class}, (Object[])genericInterfaceTypes.toArray());
        genericInterfaceTypes = ReflectTools.getGenericInterfaceTypes(HasInterfaceMulti.class, TestInterfaceMulti.class);
        Assert.assertArrayEquals((Object[])new Class[]{String.class, Integer.class, Double.class}, (Object[])genericInterfaceTypes.toArray());
        genericInterfaceTypes = ReflectTools.getGenericInterfaceTypes(ChildInterfaceMulti.class, TestInterfaceMulti.class);
        Assert.assertArrayEquals((Object[])new Class[]{Boolean.class, Float.class, Long.class}, (Object[])genericInterfaceTypes.toArray());
        genericInterfaceTypes = ReflectTools.getGenericInterfaceTypes(ChildInterfacePartial.class, TestInterfaceMulti.class);
        Assert.assertArrayEquals((Object[])new Class[]{Boolean.class, Short.class, Long.class}, (Object[])genericInterfaceTypes.toArray());
    }

    public static class ChildInterfacePartial
    extends ParentInterfacePartial<Short> {
    }

    public static class ChildInterfaceMulti
    extends ParentInterfaceMulti {
    }

    public static class ParentInterfaceMulti
    implements TestInterfaceMulti<Boolean, Float, Long> {
    }

    public static class ParentInterfacePartial<Z>
    implements TestInterfaceMulti<Boolean, Z, Long> {
    }

    public static class HasInterfaceMulti
    implements TestInterfaceMulti<String, Integer, Double> {
    }

    public static interface TestInterfaceMulti<T, R, S> {
    }

    public static class ChildInterface
    extends ParentInterface {
    }

    public static class ParentInterface
    implements TestInterface<Boolean> {
    }

    public static class HasInterface
    implements TestInterface<String> {
    }

    public static interface TestInterface<T> {
    }
}

