/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui.declarative;

import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.declarative.Design;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class DesignTest {
    private static final Charset CP1251_CHARSET = Charset.forName("cp1251");
    private static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;
    private static final String NON_ASCII_STRING = "\u043c";
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();

    @AfterClass
    public static void restoreCharset() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        DesignTest.setCharset(DEFAULT_CHARSET);
    }

    @Test
    public void write_cp1251SystemDefaultEncoding_resultEqualsToUtf8Encoding() throws IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this.setCp1251Charset();
        String cp1251Html = this.getHtml();
        this.setUtf8Charset();
        String utf8Html = this.getHtml();
        Assert.assertEquals((String)"Html written with UTF-8 as default encoding differs from html written with cp1251 encoding", (Object)cp1251Html, (Object)utf8Html);
    }

    @Test
    public void write_cp1251SystemDefaultEncoding_writtenLabelHasCorrectValue() throws IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this.setCp1251Charset();
        String cp1251Html = this.getHtml();
        Assert.assertEquals((String)"Non ascii string parsed from serialized HTML differs from expected", (Object)NON_ASCII_STRING, (Object)this.getHtmlLabelValue(cp1251Html));
    }

    @Test
    public void write_utf8SystemDefaultEncoding_writtenLabelHasCorrectValue() throws IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this.setUtf8Charset();
        String utf8 = this.getHtml();
        Assert.assertEquals((String)"Non ascii string parsed from serialized HTML differs from expected", (Object)NON_ASCII_STRING, (Object)this.getHtmlLabelValue(utf8));
    }

    private String getHtmlLabelValue(String html) {
        Document document = Jsoup.parse((String)html);
        Element label = (Element)document.select("vaadin-label").get(0);
        StringBuilder builder = new StringBuilder();
        for (Node child : label.childNodes()) {
            if (!(child instanceof TextNode)) continue;
            builder.append(((TextNode)child).getWholeText());
        }
        return builder.toString().trim();
    }

    private String getHtml() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Label label = new Label(NON_ASCII_STRING);
        Design.write((Component)label, (OutputStream)out);
        return out.toString(UTF8_CHARSET.name());
    }

    private void setCp1251Charset() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        DesignTest.setCharset(CP1251_CHARSET);
    }

    private void setUtf8Charset() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        DesignTest.setCharset(UTF8_CHARSET);
    }

    private static void setCharset(Charset charset) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field = Charset.class.getDeclaredField("defaultCharset");
        field.setAccessible(true);
        field.set(null, charset);
    }
}

