/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.ui;

import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.Page;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.UI;
import java.util.Locale;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UIInitRefreshTest {
    private boolean initCalled;
    private boolean refreshCalled;
    private boolean fragmentChangeCalled;
    private boolean browserWindowResizeCalled;

    @Before
    public void setUp() {
        this.browserWindowResizeCalled = false;
        this.fragmentChangeCalled = false;
        this.refreshCalled = false;
        this.initCalled = false;
    }

    @Test
    public void testListenersCalled() {
        IMocksControl control = EasyMock.createNiceControl();
        VaadinRequest initRequest = (VaadinRequest)control.createMock(VaadinRequest.class);
        EasyMock.expect((Object)initRequest.getParameter("v-loc")).andReturn((Object)"http://example.com/#foo");
        EasyMock.expect((Object)initRequest.getParameter("v-cw")).andReturn((Object)"100");
        EasyMock.expect((Object)initRequest.getParameter("v-ch")).andReturn((Object)"100");
        VaadinRequest reinitRequest = (VaadinRequest)control.createMock(VaadinRequest.class);
        EasyMock.expect((Object)reinitRequest.getParameter("v-loc")).andReturn((Object)"http://example.com/#bar");
        EasyMock.expect((Object)reinitRequest.getParameter("v-cw")).andReturn((Object)"200");
        EasyMock.expect((Object)reinitRequest.getParameter("v-ch")).andReturn((Object)"200");
        VaadinSession session = (VaadinSession)control.createMock(VaadinSession.class);
        DeploymentConfiguration dc = (DeploymentConfiguration)control.createMock(DeploymentConfiguration.class);
        EasyMock.expect((Object)session.hasLock()).andStubReturn((Object)true);
        EasyMock.expect((Object)session.getConfiguration()).andStubReturn((Object)dc);
        EasyMock.expect((Object)session.getLocale()).andStubReturn((Object)Locale.getDefault());
        control.replay();
        TestUI ui = new TestUI();
        ui.setSession(session);
        ui.doInit(initRequest, 0, "");
        Assert.assertTrue((boolean)this.initCalled);
        Assert.assertFalse((boolean)this.fragmentChangeCalled);
        Assert.assertFalse((boolean)this.browserWindowResizeCalled);
        ui.doRefresh(reinitRequest);
        Assert.assertTrue((boolean)this.refreshCalled);
        Assert.assertTrue((boolean)this.fragmentChangeCalled);
        Assert.assertTrue((boolean)this.browserWindowResizeCalled);
    }

    private class TestUI
    extends UI
    implements Page.UriFragmentChangedListener,
    Page.BrowserWindowResizeListener {
        private TestUI() {
        }

        protected void init(VaadinRequest request) {
            this.getPage().addBrowserWindowResizeListener((Page.BrowserWindowResizeListener)this);
            this.getPage().addUriFragmentChangedListener((Page.UriFragmentChangedListener)this);
            UIInitRefreshTest.this.initCalled = true;
            Assert.assertEquals((Object)"foo", (Object)this.getPage().getUriFragment());
            Assert.assertEquals((long)100L, (long)this.getPage().getBrowserWindowWidth());
            Assert.assertEquals((long)100L, (long)this.getPage().getBrowserWindowHeight());
            Assert.assertFalse((boolean)UIInitRefreshTest.this.fragmentChangeCalled);
            Assert.assertFalse((boolean)UIInitRefreshTest.this.browserWindowResizeCalled);
        }

        protected void refresh(VaadinRequest request) {
            UIInitRefreshTest.this.refreshCalled = true;
            Assert.assertEquals((Object)"bar", (Object)this.getPage().getUriFragment());
            Assert.assertEquals((long)200L, (long)this.getPage().getBrowserWindowWidth());
            Assert.assertEquals((long)200L, (long)this.getPage().getBrowserWindowHeight());
            Assert.assertFalse((boolean)UIInitRefreshTest.this.fragmentChangeCalled);
            Assert.assertFalse((boolean)UIInitRefreshTest.this.browserWindowResizeCalled);
        }

        public void browserWindowResized(Page.BrowserWindowResizeEvent event) {
            Assert.assertEquals((long)200L, (long)event.getWidth());
            Assert.assertEquals((long)200L, (long)event.getHeight());
            UIInitRefreshTest.this.browserWindowResizeCalled = true;
        }

        public void uriFragmentChanged(Page.UriFragmentChangedEvent event) {
            Assert.assertEquals((Object)"bar", (Object)event.getUriFragment());
            UIInitRefreshTest.this.fragmentChangeCalled = true;
        }
    }
}

